/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.io.Writer;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIForumFilter
extends UIFormInputBase<String> {
    private String defaultSelectName = null;
    private String onchange_ = null;

    public UIForumFilter() {
    }

    public UIForumFilter(String name, String bindingExpression) {
        super(name, bindingExpression, String.class);
    }

    public UIForumFilter(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    public void setDefaultSelect(String defaultSelectName) {
        this.defaultSelectName = defaultSelectName;
    }

    public String getCategoryId() {
        String value = this.value_ != null && ((String)this.value_).length() > 0 ? (String)this.value_ : " ; ";
        return value.split(";")[0].trim();
    }

    public String getForumId() {
        String value = this.value_ != null && ((String)this.value_).length() > 0 ? (String)this.value_ : " ; ";
        return value.split(";")[1].trim();
    }

    public String getForumName() {
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            String forumName = ((String)this.value_).replaceFirst(this.getCategoryId() + ";", "");
            forumName = forumName.replaceFirst(this.getForumId() + ";", "").trim();
            return forumName;
        }
        return this.getDefaultSelect().trim();
    }

    private String getDefaultSelect() {
        if (this.defaultSelectName == null) {
            this.defaultSelectName = WebUIUtils.getLabel(this.getParent().getId(), "SelectAForum");
        }
        return this.defaultSelectName;
    }

    private String getFilerPlaceholder() {
        return WebUIUtils.getLabel(this.getParent().getId(), "FilterForums");
    }

    public void decode(Object input, WebuiRequestContext context) {
        String val = (String)input;
        if (val == null || val.length() == 0) {
            return;
        }
        this.value_ = val;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.onchange_ != null && this.onchange_.length() > 0) {
            return uiForm.event(this.onchange_, this.getId());
        }
        return "";
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer w = context.getWriter();
        w.write("<div id=\"uiForumFilter");
        w.write(this.getId());
        w.write("\">\n");
        w.write("  <input name=\"");
        w.write(this.getName());
        w.write("\"");
        w.write(" type=\"hidden\"");
        w.write(" id=\"");
        w.write(this.getId());
        w.write("\"");
        String value = (String)this.getValue();
        if (value != null && value.length() > 0) {
            w.write(" value=\"");
            w.write(HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value));
            w.write("\"");
        }
        w.write("/>\n");
        w.write("  <div style=\"display:none\" class=\"forumFilterData\" data-onchange=\"");
        w.write(this.renderOnChangeEvent(uiForm));
        w.write("\"></div>\n");
        w.write("  <div class=\"uiForumFilter btn-group uiDropdownWithIcon clearfix\" ");
        this.renderHTMLAttributes(w);
        w.write(">\n");
        w.write("  <div class=\"btn dropdown-toggle\">");
        w.write("    <span class=\"titleForum\">");
        w.write(this.getForumName());
        w.write("    </span>\n");
        w.write("    <span class=\"spiter\"></span>\n");
        w.write("    <span class=\"caret\"></span>\n");
        w.write("</div>\n");
        w.write("    <div class=\"filterMenu open\" style=\"position:absolute; visibility:hidden\">\n");
        w.write("      <ul class=\"dropdown-menu\">\n");
        w.write("        <li>\n");
        w.write("          <input type=\"text\" class=\"filterInput\" placeholder=\"" + this.getFilerPlaceholder() + "\"/>\n");
        w.write("        </li>\n");
        w.write("      </ul>\n");
        w.write("    </div>\n");
        w.write("  </div>\n");
        w.write("</div>\n");
        context.getJavascriptManager().getRequireJS().require("SHARED/forumFilter", "forumfilter").addScripts("forumfilter.init('uiForumFilter" + this.getId() + "');");
    }
}

