/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.MutableBaseSession;
import org.josso.gateway.session.service.SSOSessionManagerService;
import org.josso.gateway.ws._1_2.protocol.AccessSessionRequestType;
import org.josso.gateway.ws._1_2.protocol.NoSuchSessionErrorType;
import org.josso.gateway.ws._1_2.protocol.SSOSessionErrorType;
import org.josso.gateway.ws._1_2.protocol.SSOSessionType;
import org.josso.gateway.ws._1_2.protocol.SessionRequestType;
import org.josso.gateway.ws._1_2.protocol.SessionResponseType;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManager;

public class WebserviceSSOSessionManager
implements SSOSessionManagerService {
    private static final Log logger = LogFactory.getLog(WebserviceSSOSessionManager.class);
    private SSOSessionManager _wsSSOSessionManager;
    private long _processedCount;
    private long _errorCount;

    public WebserviceSSOSessionManager(SSOSessionManager wsSSOSessionManager) {
        this._wsSSOSessionManager = wsSSOSessionManager;
    }

    public void accessSession(String requester, String sessionId) throws NoSuchSessionException, SSOSessionException {
        try {
            AccessSessionRequestType request = new AccessSessionRequestType();
            request.setRequester(requester);
            request.setSsoSessionId(sessionId);
            this._wsSSOSessionManager.accessSession(request);
        }
        catch (NoSuchSessionErrorType e) {
            throw new NoSuchSessionException(e.getSessionId());
        }
        catch (SSOSessionErrorType e) {
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public SSOSession getSession(String requester, String sessionId) throws NoSuchSessionException, SSOSessionException {
        try {
            SessionRequestType request = new SessionRequestType();
            request.setRequester(requester);
            request.setSessionId(sessionId);
            SessionResponseType response = this._wsSSOSessionManager.getSession(request);
            SSOSession sSOSession = this.adaptSSOSession(response.getSSOSession());
            return sSOSession;
        }
        catch (NoSuchSessionErrorType e) {
            throw new NoSuchSessionException(e.getSessionId());
        }
        catch (SSOSessionErrorType e) {
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public long getErrorCount() {
        return this._errorCount;
    }

    public long getProcessedCount() {
        return this._processedCount;
    }

    protected SSOSession adaptSSOSession(SSOSessionType srcSSOSession) {
        MutableBaseSession targetSSOSession = new MutableBaseSession();
        targetSSOSession.setId(srcSSOSession.getId());
        targetSSOSession.setCreationTime(srcSSOSession.getCreationTime());
        targetSSOSession.setLastAccessedTime(srcSSOSession.getLastAccessTime());
        targetSSOSession.setMaxInactiveInterval(srcSSOSession.getMaxInactiveInterval());
        targetSSOSession.setUsername(srcSSOSession.getUsername());
        targetSSOSession.setAccessCount(srcSSOSession.getAccessCount());
        targetSSOSession.setValid(srcSSOSession.isValid());
        return targetSSOSession;
    }
}

