/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.config;

import org.picketlink.identity.federation.core.config.EncryptionType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.util.StringUtil;

public class IDPType
extends ProviderType {
    protected EncryptionType encryption;
    protected String roleGenerator;
    protected String attributeManager;
    protected Boolean encrypt;
    private boolean strictPostBinding = true;
    private String identityParticipantStack = null;

    public EncryptionType getEncryption() {
        return this.encryption;
    }

    public void setEncryption(EncryptionType value) {
        this.encryption = value;
    }

    public String getRoleGenerator() {
        if (this.roleGenerator == null) {
            return "org.picketlink.identity.federation.bindings.tomcat.TomcatRoleGenerator";
        }
        return this.roleGenerator;
    }

    public void setRoleGenerator(String value) {
        this.roleGenerator = value;
    }

    public String getAttributeManager() {
        if (this.attributeManager == null) {
            return "org.picketlink.identity.federation.bindings.tomcat.TomcatAttributeManager";
        }
        return this.attributeManager;
    }

    public void setAttributeManager(String value) {
        this.attributeManager = value;
    }

    public boolean isEncrypt() {
        if (this.encrypt == null) {
            return false;
        }
        return this.encrypt;
    }

    public void setEncrypt(Boolean value) {
        this.encrypt = value;
    }

    public void importFrom(IDPType other) {
        super.importFrom(other);
        String attributeManager = other.getAttributeManager();
        if (StringUtil.isNotNull(attributeManager)) {
            this.setAttributeManager(attributeManager);
        }
        this.encrypt = other.isEncrypt();
        if (StringUtil.isNotNull(other.getRoleGenerator())) {
            this.roleGenerator = other.getRoleGenerator();
        }
    }

    public void setStrictPostBinding(boolean strictPostBinding) {
        this.strictPostBinding = strictPostBinding;
    }

    public boolean isStrictPostBinding() {
        return this.strictPostBinding;
    }

    public void setIdentityParticipantStack(String identityParticipantStack) {
        this.identityParticipantStack = identityParticipantStack;
    }

    public String getIdentityParticipantStack() {
        return this.identityParticipantStack;
    }
}

