/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static InputStream loadStream(final Class<?> theClass, final String fqn) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = theClass.getClassLoader();
                InputStream is = classLoader.getResourceAsStream(fqn);
                if (is == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fqn);
                }
                return is;
            }
        });
    }

    static Class<?> loadClass(final Class<?> theClass, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                ClassLoader classLoader = theClass.getClassLoader();
                Class<?> clazz = SecurityActions.loadClass(classLoader, fqn);
                if (clazz == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = SecurityActions.loadClass(classLoader, fqn);
                }
                return clazz;
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return cl.loadClass(fqn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }
}

