/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.social.common.jcr.filter.FilterLiteral;

public abstract class AbstractFilterLiteral<P>
implements FilterLiteral<P> {
    private List<FilterLiteral.FilterOption<P>> filterOptions = new ArrayList<FilterLiteral.FilterOption<P>>(0);
    private List<FilterLiteral.OrderByOption<P>> orderByOptions = new ArrayList<FilterLiteral.OrderByOption<P>>(0);

    protected abstract void start();

    public abstract void destroy();

    public AbstractFilterLiteral() {
        this.start();
    }

    @Override
    public FilterLiteral<P> append(FilterLiteral.OrderByOption<P> orderBy) {
        if (!this.orderByOptions.contains(orderBy)) {
            ArrayList<FilterLiteral.OrderByOption<P>> results = new ArrayList<FilterLiteral.OrderByOption<P>>(this.orderByOptions.size() + 1);
            results.addAll(this.orderByOptions);
            orderBy.setTarget(this);
            results.add(orderBy);
            this.orderByOptions = results;
        }
        return this;
    }

    @Override
    public FilterLiteral.OrderByOption<P> with(FilterLiteral.OrderByOption<P> orderBy) {
        this.append(orderBy);
        return this.get(orderBy);
    }

    @Override
    public FilterLiteral<P> remove(FilterLiteral.OrderByOption<P> orderBy) {
        this.orderByOptions.remove(orderBy);
        return this;
    }

    @Override
    public void clear() {
        this.filterOptions = new ArrayList<FilterLiteral.FilterOption<P>>(0);
        this.orderByOptions = new ArrayList<FilterLiteral.OrderByOption<P>>(0);
    }

    @Override
    public FilterLiteral.OrderByOption<P> get(FilterLiteral.OrderByOption<P> orderBy) {
        return this.orderByOptions.indexOf(orderBy) > -1 ? this.orderByOptions.get(this.orderByOptions.indexOf(orderBy)) : null;
    }

    @Override
    public Iterator<FilterLiteral.OrderByOption<P>> getOrders() {
        return this.orderByOptions.iterator();
    }

    @Override
    public FilterLiteral<P> append(FilterLiteral.FilterOption<P> filter) {
        if (!this.filterOptions.contains(filter)) {
            ArrayList<FilterLiteral.FilterOption<P>> results = new ArrayList<FilterLiteral.FilterOption<P>>(this.filterOptions.size() + 1);
            results.addAll(this.filterOptions);
            filter.setTarget(this);
            results.add(filter);
            this.filterOptions = results;
        }
        return this;
    }

    @Override
    public FilterLiteral<P> remove(FilterLiteral.FilterOption<P> filter) {
        this.filterOptions.remove(filter);
        return this;
    }

    @Override
    public FilterLiteral.FilterOption<P> get(FilterLiteral.FilterOption<P> filter) {
        return this.filterOptions.indexOf(filter) > -1 ? this.filterOptions.get(this.filterOptions.indexOf(filter)) : null;
    }

    @Override
    public FilterLiteral.FilterOption<P> with(FilterLiteral.FilterOption<P> filter) {
        this.append(filter);
        return this.get(filter);
    }
}

