/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;

class CreateSyntheticBlocks
implements CompilerPass {
    static final DiagnosticType UNMATCHED_START_MARKER = DiagnosticType.warning("JSC_UNMATCHED_START_MARKER", "Unmatched {0}");
    static final DiagnosticType UNMATCHED_END_MARKER = DiagnosticType.warning("JSC_UNMATCHED_END_MARKER", "Unmatched {1} - {0} not in the same block");
    static final DiagnosticType INVALID_MARKER_USAGE = DiagnosticType.warning("JSC_INVALID_MARKER_USAGE", "Marker {0} can only be used in a simple call expression");
    private final AbstractCompiler compiler;
    private final String startMarkerName;
    private final String endMarkerName;
    private final Deque<Node> markerStack = new ArrayDeque<Node>();
    private final List<Marker> validMarkers = Lists.newArrayList();

    public CreateSyntheticBlocks(AbstractCompiler compiler, String startMarkerName, String endMarkerName) {
        this.compiler = compiler;
        this.startMarkerName = startMarkerName;
        this.endMarkerName = endMarkerName;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Callback());
        for (Node node : this.markerStack) {
            this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node, UNMATCHED_START_MARKER, this.startMarkerName));
        }
        for (Marker marker : this.validMarkers) {
            this.addBlocks(marker);
        }
    }

    private void addBlocks(Marker marker) {
        Node originalParent = marker.endMarker.getParent();
        Node outerBlock = new Node(125);
        outerBlock.setIsSyntheticBlock(true);
        originalParent.addChildBefore(outerBlock, marker.startMarker);
        Node innerBlock = new Node(125);
        innerBlock.setIsSyntheticBlock(true);
        this.moveSiblingExclusive(originalParent, innerBlock, marker.startMarker, marker.endMarker);
        outerBlock.addChildToBack(originalParent.removeChildAfter(outerBlock));
        outerBlock.addChildToBack(innerBlock);
        outerBlock.addChildToBack(originalParent.removeChildAfter(outerBlock));
        this.compiler.reportCodeChange();
    }

    private void moveSiblingExclusive(Node src, Node dest, @Nullable Node start, @Nullable Node end) {
        while (this.childAfter(src, start) != end) {
            Node child = this.removeChildAfter(src, start);
            dest.addChildToBack(child);
        }
    }

    private Node childAfter(Node parent, @Nullable Node siblingBefore) {
        if (siblingBefore == null) {
            return parent.getFirstChild();
        }
        return siblingBefore.getNext();
    }

    private Node removeChildAfter(Node parent, @Nullable Node siblingBefore) {
        if (siblingBefore == null) {
            return parent.removeFirstChild();
        }
        return parent.removeChildAfter(siblingBefore);
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() != 37 || n.getFirstChild().getType() != 38) {
                return;
            }
            Node callTarget = n.getFirstChild();
            String callName = callTarget.getString();
            if (CreateSyntheticBlocks.this.startMarkerName.equals(callName)) {
                if (parent.getType() != 130) {
                    CreateSyntheticBlocks.this.compiler.report(t.makeError(n, INVALID_MARKER_USAGE, CreateSyntheticBlocks.this.startMarkerName));
                    return;
                }
                CreateSyntheticBlocks.this.markerStack.push(parent);
                return;
            }
            if (!CreateSyntheticBlocks.this.endMarkerName.equals(callName)) {
                return;
            }
            Node endMarkerNode = parent;
            if (endMarkerNode.getType() != 130) {
                CreateSyntheticBlocks.this.compiler.report(t.makeError(n, INVALID_MARKER_USAGE, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            if (CreateSyntheticBlocks.this.markerStack.isEmpty()) {
                CreateSyntheticBlocks.this.compiler.report(t.makeError(n, UNMATCHED_END_MARKER, CreateSyntheticBlocks.this.startMarkerName, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            Node startMarkerNode = (Node)CreateSyntheticBlocks.this.markerStack.pop();
            if (endMarkerNode.getParent() != startMarkerNode.getParent()) {
                CreateSyntheticBlocks.this.compiler.report(t.makeError(n, UNMATCHED_END_MARKER, CreateSyntheticBlocks.this.startMarkerName, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            CreateSyntheticBlocks.this.validMarkers.add(new Marker(startMarkerNode, endMarkerNode));
        }
    }

    private class Marker {
        final Node startMarker;
        final Node endMarker;

        public Marker(Node startMarker, Node endMarker) {
            this.startMarker = startMarker;
            this.endMarker = endMarker;
        }
    }
}

