/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.LinkedHashSet;

class GroupVariableDeclarations
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;

    GroupVariableDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        LinkedHashSet varNodes = Sets.newLinkedHashSet();
        Iterator<Scope.Var> scopeVarIter = t.getScope().getVars();
        while (scopeVarIter.hasNext()) {
            Node parentNode = scopeVarIter.next().getParentNode();
            if (!parentNode.isVar()) continue;
            varNodes.add(parentNode);
        }
        if (varNodes.size() <= 1) {
            return;
        }
        Iterator varNodeIter = varNodes.iterator();
        Node firstVarNode = (Node)varNodeIter.next();
        while (varNodeIter.hasNext()) {
            Node varNode = (Node)varNodeIter.next();
            this.applyGroupingToVar(firstVarNode, varNode);
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private void applyGroupingToVar(Node firstVar, Node groupVar) {
        Node initializedName = null;
        for (Node child = groupVar.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.hasChildren()) continue;
            if (initializedName != null) {
                return;
            }
            initializedName = child;
        }
        Node groupVarParent = groupVar.getParent();
        if (initializedName != null) {
            if (NodeUtil.isForIn(groupVarParent)) {
                return;
            }
            Node clone = initializedName.cloneNode();
            groupVar.replaceChild(initializedName, clone);
            Node initializedVal = initializedName.getFirstChild();
            initializedName.removeChild(initializedVal);
            Node assignmentNode = new Node(86, initializedName);
            assignmentNode.addChildAfter(initializedVal, initializedName);
            if (groupVarParent.isFor()) {
                groupVarParent.replaceChild(groupVar, assignmentNode);
            } else {
                Node exprNode = NodeUtil.newExpr(assignmentNode);
                groupVarParent.replaceChild(groupVar, exprNode);
            }
        } else if (groupVarParent.isFor()) {
            if (NodeUtil.isForIn(groupVarParent)) {
                Node nameNodeClone = groupVar.getFirstChild().cloneNode();
                groupVarParent.replaceChild(groupVar, nameNodeClone);
            } else {
                Node emptyNode = new Node(124);
                groupVarParent.replaceChild(groupVar, emptyNode);
            }
        } else {
            groupVarParent.removeChild(groupVar);
        }
        Node children = groupVar.removeChildren();
        firstVar.addChildrenToBack(children);
        this.compiler.reportCodeChange();
    }
}

