/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Void setContextClassLoader(final ClassLoader cl) {
        return AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static URL findResource(final URLClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return cl.findResource(name);
            }
        });
    }

    static InputStream openStream(final URL url) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return url.openStream();
            }
        });
    }

    static Class<?> loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws ClassNotFoundException {
                ClassLoader[] cls = new ClassLoader[]{SecurityActions.getContextClassLoader(), SecurityActions.class.getClassLoader(), ClassLoader.getSystemClassLoader()};
                ClassNotFoundException e = null;
                for (ClassLoader cl : cls) {
                    if (cl == null) continue;
                    try {
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException ce) {
                        e = ce;
                    }
                }
                throw e != null ? e : new ClassNotFoundException(name);
            }
        });
    }
}

