/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js.scope;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.parser.js.scope.AbstractScope;
import com.google.caja.parser.js.scope.ScopeListener;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScopeAnalyzer<S extends AbstractScope> {
    private final ScopeListener<S> listener;

    protected ScopeAnalyzer(ScopeListener<S> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    protected abstract boolean fnCtorsDeclareInBody();

    protected abstract boolean fnCtorsDeclareInContaining();

    public S apply(AncestorChain<? extends ParseTreeNode> ac) {
        ScopeTree<S> root = this.buildScopeTree(ac, null);
        this.publishEvents(root);
        return (S)((AbstractScope)root.scopeImpl);
    }

    private ScopeTree<S> buildScopeTree(AncestorChain<?> ac, ScopeTree<S> outer) {
        ScopeTree<S> scope = outer;
        ScopeType t = ScopeType.forNode(ac.node);
        if (!(outer != null || t != null && t.isDeclarationContainer)) {
            t = ScopeType.PROGRAM;
        }
        if (t != null) {
            scope = new ScopeTree<S>(outer, t, this.listener.createScope(t, ac, ScopeAnalyzer.scopeImpl(outer)));
            if (t == ScopeType.WITH) {
                AncestorChain<WithStmt> with = ac.cast(WithStmt.class);
                this.buildScopeTree(with.child(((WithStmt)with.node).getScopeObject()), outer);
                this.buildScopeTree(with.child(((WithStmt)with.node).getBody()), scope);
                return scope;
            }
        }
        scope.inScope.add(ac);
        if (ac.node instanceof Declaration) {
            AncestorChain<Declaration> d = ac.cast(Declaration.class);
            AncestorChain<Identifier> ancestorChain = d.child(((Declaration)d.node).getIdentifier());
            Symbol<S> symbol = new Symbol<S>(ancestorChain, scope);
            this.hoist(ancestorChain, scope).declarations.add(symbol);
            if (((Declaration)d.node).getInitializer() != null || ScopeAnalyzer.isKeyReceiver(d)) {
                scope.uses.add(symbol);
            }
        } else if (ac.node instanceof Reference) {
            AncestorChain<Reference> r = ac.cast(Reference.class);
            if (!ScopeAnalyzer.isPropertyName(r)) {
                scope.uses.add(new Symbol<S>(r.child(((Reference)r.node).getIdentifier()), scope));
            }
        } else if (ac.node instanceof FunctionConstructor) {
            AncestorChain<FunctionConstructor> f = ac.cast(FunctionConstructor.class);
            AncestorChain<Identifier> ancestorChain = f.child(((FunctionConstructor)f.node).getIdentifier());
            if (((Identifier)ancestorChain.node).getName() != null) {
                if (this.fnCtorsDeclareInBody()) {
                    scope.declarations.add(new Symbol<S>(ancestorChain, scope));
                }
                if (this.fnCtorsDeclareInContaining() && ac.parent != null && !(ac.parent.node instanceof FunctionDeclaration)) {
                    scope.outer.declarations.add(new Symbol(ancestorChain, scope.outer));
                }
            }
        }
        for (ParseTreeNode parseTreeNode : ac.node.children()) {
            this.buildScopeTree(ac.child(parseTreeNode), scope);
        }
        return scope;
    }

    private void publishEvents(ScopeTree<S> s) {
        AbstractScope scopeImpl = (AbstractScope)s.scopeImpl;
        this.listener.enterScope(scopeImpl);
        for (AncestorChain<?> ancestorChain : s.inScope) {
            this.listener.inScope(ancestorChain, (AbstractScope)s.scopeImpl);
        }
        for (Symbol symbol : s.declarations) {
            this.declare(symbol.id, symbol.useScope);
        }
        for (ScopeTree scopeTree : s.innerScopes) {
            this.publishEvents(scopeTree);
        }
        for (Symbol symbol : s.uses) {
            this.handleUse(symbol.id, symbol.useScope);
        }
        this.listener.exitScope(scopeImpl);
    }

    private void handleUse(AncestorChain<Identifier> id, ScopeTree<S> s) {
        Object n = id.parent.node;
        if (n instanceof Reference) {
            String symbolName = ((Identifier)id.node).getName();
            ScopeTree<S> defSite = this.definingSite(symbolName, s);
            Operator assignOperator = ScopeAnalyzer.assignOperator(id);
            if (assignOperator == null) {
                this.listener.read(id, (AbstractScope)s.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(defSite));
            } else if (assignOperator == Operator.ASSIGN) {
                this.listener.assigned(id, (AbstractScope)s.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(defSite));
            } else {
                this.listener.read(id, (AbstractScope)s.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(defSite));
                this.listener.assigned(id, (AbstractScope)s.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(defSite));
            }
        } else if (n instanceof Declaration) {
            ScopeTree<S> defSite = this.definingSite(((Identifier)id.node).getName(), s);
            this.listener.assigned(id, (AbstractScope)s.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(defSite));
        } else {
            throw new ClassCastException("Unexpected use " + n);
        }
    }

    private static Operator assignOperator(AncestorChain<Identifier> ac) {
        ForEachLoop loop;
        if (ac.parent == null) {
            return null;
        }
        if (!(ac.parent.node instanceof Reference)) {
            return null;
        }
        AncestorChain<? extends ParseTreeNode> grandparent = ac.parent.parent;
        if (grandparent == null) {
            return null;
        }
        if (grandparent.node instanceof Operation) {
            Operation op = (Operation)grandparent.cast(Operation.class).node;
            Operator operator = op.getOperator();
            return operator.getCategory() == OperatorCategory.ASSIGNMENT && ac.parent.node == op.children().get(0) ? operator : null;
        }
        if (grandparent.node instanceof ExpressionStmt && grandparent.parent != null && grandparent.parent.node instanceof ForEachLoop && grandparent.node == (loop = (ForEachLoop)grandparent.parent.cast(ForEachLoop.class).node).getKeyReceiver()) {
            return Operator.ASSIGN;
        }
        return null;
    }

    private ScopeTree<S> definingSite(String symbolName, ScopeTree<S> useSite) {
        if ("this".equals(symbolName)) {
            ScopeTree<S> s = useSite;
            while (s != null) {
                if (s.type == ScopeType.FUNCTION || s.type == ScopeType.PROGRAM) {
                    return s;
                }
                s = s.outer;
            }
        } else if ("arguments".equals(symbolName)) {
            ScopeTree<S> s = useSite;
            while (s != null) {
                if (s.type == ScopeType.FUNCTION || s.declared.contains(symbolName)) {
                    return s;
                }
                s = s.outer;
            }
        } else {
            ScopeTree<S> s = useSite;
            while (s != null) {
                if (s.declared.contains(symbolName)) {
                    return s;
                }
                s = s.outer;
            }
        }
        return null;
    }

    private static boolean isPropertyName(AncestorChain<Reference> ac) {
        return ac.parent != null && Operation.is(ac.parent.node, Operator.MEMBER_ACCESS) && ac.node == ac.parent.node.children().get(1);
    }

    private static boolean isKeyReceiver(AncestorChain<Declaration> ac) {
        return ac.parent != null && ac.parent.node instanceof ForEachLoop && ac.node == ac.parent.node.children().get(0);
    }

    private static String nameAssignedTo(AncestorChain<?> ac) {
        if (ac.parent == null) {
            return null;
        }
        if (ac.parent.node instanceof Declaration) {
            return ((Declaration)ac.parent.cast(Declaration.class).node).getIdentifierName();
        }
        if (Operation.is(ac.parent.node, Operator.ASSIGN)) {
            ParseTreeNode lhs = ac.parent.node.children().get(0);
            return lhs instanceof Reference ? ((Reference)lhs).getIdentifierName() : null;
        }
        return null;
    }

    private ScopeTree<S> hoist(AncestorChain<Identifier> id, ScopeTree<S> scope) {
        ScopeTree<S> declScope = scope;
        if (id.parent.parent == null || !(id.parent.parent.node instanceof CatchStmt)) {
            while (!declScope.type.isDeclarationContainer) {
                declScope = declScope.outer;
            }
        }
        return declScope;
    }

    private void declare(AncestorChain<Identifier> id, ScopeTree<S> scope) {
        String symbolName = ((Identifier)id.node).getName();
        ScopeTree<S> declScope = this.hoist(id, scope);
        ScopeTree<S> s = scope;
        while (s != declScope) {
            if (s.type == ScopeType.CATCH) {
                AncestorChain<CatchStmt> cs = s.inScope.get(0).cast(CatchStmt.class);
                AncestorChain<Declaration> ex = cs.child(((CatchStmt)cs.node).getException());
                Identifier exId = ((Declaration)ex.node).getIdentifier();
                if (symbolName.equals(exId.getName())) {
                    this.listener.splitInitialization(id, (AbstractScope)declScope.scopeImpl, ex.child(exId), (AbstractScope)s.scopeImpl);
                }
            }
            s = s.outer;
        }
        ScopeTree<S> maskedScope = this.definingSite(symbolName, declScope);
        declScope.declared.add(symbolName);
        this.listener.declaration(id, (AbstractScope)declScope.scopeImpl);
        if (!(maskedScope == null || id.parent.node instanceof FunctionConstructor && symbolName.equals(ScopeAnalyzer.nameAssignedTo(id.parent)))) {
            if (maskedScope == scope) {
                this.listener.duplicate(id, (AbstractScope)declScope.scopeImpl);
            } else {
                this.listener.masked(id, (AbstractScope)declScope.scopeImpl, (AbstractScope)ScopeAnalyzer.scopeImpl(maskedScope));
            }
        }
    }

    private static <S extends AbstractScope> S scopeImpl(ScopeTree<S> s) {
        return (S)(s != null ? (AbstractScope)s.scopeImpl : null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Symbol<S> {
        final AncestorChain<Identifier> id;
        final ScopeTree<S> useScope;

        Symbol(AncestorChain<Identifier> id, ScopeTree<S> useScope) {
            this.id = id;
            this.useScope = useScope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScopeTree<S> {
        final ScopeTree<S> outer;
        final ScopeType type;
        final S scopeImpl;
        final List<ScopeTree<S>> innerScopes = Lists.newArrayList();
        final List<AncestorChain<?>> inScope = Lists.newArrayList();
        final List<Symbol<S>> declarations = Lists.newArrayList();
        final List<Symbol<S>> uses = Lists.newArrayList();
        final Set<String> declared = Sets.newHashSet();

        ScopeTree(ScopeTree<S> outer, ScopeType t, S scopeImpl) {
            this.outer = outer;
            this.type = t;
            this.scopeImpl = scopeImpl;
            if (outer != null) {
                outer.innerScopes.add(this);
            }
        }
    }
}

