/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class)
public class ContentPresentation
extends UIBaseNodePresentation {
    private static final Log LOG = ExoLogger.getLogger(ContentPresentation.class);
    private Node node;
    private JCRResourceResolver resourceResolver;

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() throws Exception {
        return this.node;
    }

    public Node getOriginalNode() throws Exception {
        return this.node;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        String mimeType = jcrContentNode.getProperty("jcr:mimeType").getString();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, mimeType);
        DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
        String ext = mimeTypeSolver.getExtension(mimeType);
        StringBuffer fileNameStrBuffer = new StringBuffer(node.getName());
        if (fileNameStrBuffer.lastIndexOf("." + ext) < 0) {
            fileNameStrBuffer.append(".").append(ext);
        }
        dresource.setDownloadName(fileNameStrBuffer.toString());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePath(this.getOriginalNode(), false);
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Catch an exception when getting template, return value NULL.\n Cause by: ", (Throwable)e);
            }
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
            this.resourceResolver = new JCRResourceResolver(workspace);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIMessageBoard.msg.get-template-resource", null, (int)0);
        }
        return this.resourceResolver;
    }

    public String getNodeType() throws Exception {
        return this.getOriginalNode().getPrimaryNodeType().getName();
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        if (mimeType != null && !mimeType.startsWith("text") && !mimeType.startsWith("application")) {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("mimeType", mimeType);
            for (UIExtension extension : extensions) {
                UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
                if (uiComponent == null) continue;
                return uiComponent;
            }
        }
        return null;
    }

    public UIComponent getCommentComponent() throws Exception {
        return null;
    }

    public UIComponent getRemoveAttach() throws Exception {
        return null;
    }

    public UIComponent getRemoveComment() throws Exception {
        return null;
    }

    public String getRepositoryName() throws Exception {
        return ((ManageableRepository)this.getNode().getSession().getRepository()).getConfiguration().getName();
    }
}

