/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.queries.impl.QueryPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class QueryServiceImpl
implements QueryService,
Startable {
    private static final String[] perms = new String[]{"read", "add_node", "set_property", "remove"};
    private String relativePath_;
    private List<QueryPlugin> queryPlugins_ = new ArrayList<QueryPlugin>();
    private RepositoryService repositoryService_;
    private ExoCache<String, QueryResult> cache_;
    private PortalContainerInfo containerInfo_;
    private OrganizationService organizationService_;
    private String baseUserPath_;
    private String baseQueriesPath_;
    private String group_;
    private DMSConfiguration dmsConfiguration_;
    private Set<String> configuredQueries_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final Log LOG = ExoLogger.getLogger((String)QueryServiceImpl.class.getName());

    public QueryServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params, PortalContainerInfo containerInfo, CacheService cacheService, OrganizationService organizationService, DMSConfiguration dmsConfiguration) throws Exception {
        this.relativePath_ = params.getValueParam("relativePath").getValue();
        this.group_ = params.getValueParam("group").getValue();
        this.repositoryService_ = repositoryService;
        this.containerInfo_ = containerInfo;
        this.cache_ = cacheService.getCacheInstance("ecm.query");
        this.organizationService_ = organizationService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseUserPath_ = nodeHierarchyCreator.getJcrPath("usersPath");
        this.baseQueriesPath_ = nodeHierarchyCreator.getJcrPath("queriesPath");
        this.dmsConfiguration_ = dmsConfiguration;
    }

    public void start() {
        this.configuredQueries_ = new HashSet<String>();
        for (QueryPlugin queryPlugin : this.queryPlugins_) {
            try {
                queryPlugin.init(this.baseQueriesPath_);
                this.configuredQueries_.addAll(queryPlugin.getAllConfiguredQueries());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Can not start query plugin '" + queryPlugin.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init() throws Exception {
        this.configuredQueries_ = new HashSet<String>();
        for (QueryPlugin queryPlugin : this.queryPlugins_) {
            try {
                queryPlugin.init(this.baseQueriesPath_);
                this.configuredQueries_.addAll(queryPlugin.getAllConfiguredQueries());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Can not init query plugin '" + queryPlugin.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void setQueryPlugin(QueryPlugin queryPlugin) {
        this.queryPlugins_.add(queryPlugin);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath_;
    }

    @Override
    public List<Query> getQueries(String userName, SessionProvider provider) throws Exception {
        Node userHome;
        Node usersHome;
        QueryManager manager;
        ArrayList<Query> queries;
        block11: {
            queries = new ArrayList<Query>();
            if (userName == null) {
                return queries;
            }
            Session session = this.getSession(provider, true);
            manager = session.getWorkspace().getQueryManager();
            try {
                usersHome = (Node)session.getItem(this.baseUserPath_);
            }
            catch (PathNotFoundException e) {
                usersHome = (Node)this.getSession(provider, false).getItem(this.baseUserPath_);
            }
            userHome = null;
            try {
                userHome = this.nodeHierarchyCreator_.getUserNode(provider, userName);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (userHome == null) {
            if (usersHome.hasNode(userName)) {
                userHome = usersHome.getNode(userName);
            } else {
                userHome = usersHome.addNode(userName);
                if (userHome.canAddMixin("exo:privilegeable")) {
                    userHome.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)userHome).setPermissions(this.getPermissions(userName));
                Node query = null;
                query = userHome.hasNode(this.relativePath_) ? userHome.getNode(this.relativePath_) : this.getNodeByRelativePath(userHome, this.relativePath_);
                if (query.canAddMixin("exo:privilegeable")) {
                    query.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)query).setPermissions(this.getPermissions(userName));
                usersHome.save();
            }
        }
        Node queriesHome = null;
        queriesHome = userHome.hasNode(this.relativePath_) ? userHome.getNode(this.relativePath_) : this.getNodeByRelativePath(userHome, this.relativePath_);
        NodeIterator iter = queriesHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!node.isNodeType("nt:query")) continue;
            queries.add(manager.getQuery(node));
        }
        return queries;
    }

    private Node getNodeByRelativePath(Node userHome, String relativePath) throws Exception {
        String[] paths = relativePath.split("/");
        StringBuffer relPath = null;
        Node queriesHome = null;
        for (String path : paths) {
            if (relPath == null) {
                relPath = new StringBuffer(path);
            } else {
                relPath.append("/").append(path);
            }
            if (userHome.hasNode(relPath.toString())) continue;
            queriesHome = userHome.addNode(relPath.toString());
        }
        return queriesHome;
    }

    private Map<String, String[]> getPermissions(String owner) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put(owner, perms);
        permissions.put(this.group_, perms);
        return permissions;
    }

    @Override
    public void addQuery(String queryName, String statement, String language, String userName) throws Exception {
        if (userName == null) {
            return;
        }
        Session session = this.getSession();
        QueryManager manager = session.getWorkspace().getQueryManager();
        Query query = manager.createQuery(statement, language);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
        if (!userNode.hasNode(this.getRelativePath())) {
            this.getNodeByRelativePath(userNode, this.relativePath_);
            session.save();
        }
        String absPath = userNode.getPath() + "/" + this.relativePath_ + "/" + queryName;
        query.storeAsNode(absPath);
        session.save();
    }

    @Override
    public void removeQuery(String queryPath, String userName) throws Exception {
        if (userName == null) {
            return;
        }
        Session session = this.getSession();
        Node queryNode = null;
        try {
            queryNode = (Node)session.getItem(queryPath);
        }
        catch (PathNotFoundException pe) {
            queryNode = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider(), true).getItem(queryPath);
        }
        Node queriesHome = queryNode.getParent();
        queryNode.remove();
        queriesHome.save();
        this.removeFromCache(queryPath);
    }

    @Override
    public void addSharedQuery(String queryName, String statement, String language, String[] permissions, boolean cachedResult) throws Exception {
        this.addSharedQuery(queryName, statement, language, permissions, cachedResult, WCMCoreUtils.getUserSessionProvider());
    }

    @Override
    public void addSharedQuery(String queryName, String statement, String language, String[] permissions, boolean cachedResult, SessionProvider provider) throws Exception {
        String queryPath;
        Session session = this.getSession(provider, true);
        ValueFactory vt = session.getValueFactory();
        ArrayList<Value> perm = new ArrayList<Value>();
        for (String permission : permissions) {
            Value vl = vt.createValue(permission);
            perm.add(vl);
        }
        Value[] vls = perm.toArray(new Value[0]);
        String queriesPath = this.baseQueriesPath_;
        Node queryHome = (Node)session.getItem(this.baseQueriesPath_);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        queryManager.createQuery(statement, language);
        if (queryHome.hasNode(queryName)) {
            Node query = queryHome.getNode(queryName);
            query.setProperty("jcr:language", language);
            query.setProperty("jcr:statement", statement);
            query.setProperty("exo:accessPermissions", vls);
            query.setProperty("exo:cachedResult", cachedResult);
            query.save();
            session.save();
            queryPath = query.getPath();
        } else {
            QueryManager manager = session.getWorkspace().getQueryManager();
            Query query = manager.createQuery(statement, language);
            Node newQuery = query.storeAsNode(this.baseQueriesPath_ + "/" + queryName);
            newQuery.addMixin("mix:sharedQuery");
            newQuery.setProperty("exo:accessPermissions", vls);
            newQuery.setProperty("exo:cachedResult", cachedResult);
            session.getItem(queriesPath).save();
            queryPath = queriesPath;
        }
        this.removeFromCache(queryPath);
    }

    @Override
    public Node getSharedQuery(String queryName, SessionProvider provider) throws Exception {
        Session session = this.getSession(provider, true);
        try {
            Node sharedQueryNode = (Node)session.getItem(this.baseQueriesPath_ + "/" + queryName);
            return sharedQueryNode;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Node> getSharedQueries(SessionProvider provider) throws Exception {
        Session session = this.getSession(provider, true);
        ArrayList<Node> queries = new ArrayList<Node>();
        Node sharedQueryHome = (Node)session.getItem(this.baseQueriesPath_);
        NodeIterator iter = sharedQueryHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!node.isNodeType("nt:query")) continue;
            queries.add(node);
        }
        return queries;
    }

    @Override
    public List<Node> getSharedQueries(String userId, SessionProvider provider) throws Exception {
        ArrayList<Node> sharedQueries = new ArrayList<Node>();
        for (Node query : this.getSharedQueries(provider)) {
            if (!this.canUseQuery(userId, query)) continue;
            sharedQueries.add(query);
        }
        return sharedQueries;
    }

    @Override
    public List<Node> getSharedQueries(String queryType, String userId, SessionProvider provider) throws Exception {
        ArrayList<Node> resultList = new ArrayList<Node>();
        String language = null;
        for (Node queryNode : this.getSharedQueries(provider)) {
            language = queryNode.getProperty("jcr:language").getString();
            if (!queryType.equalsIgnoreCase(language) || !this.canUseQuery(userId, queryNode)) continue;
            resultList.add(queryNode);
        }
        return resultList;
    }

    @Override
    public Query getQueryByPath(String queryPath, String userName, SessionProvider provider) throws Exception {
        List<Query> queries = this.getQueries(userName, provider);
        for (Query query : queries) {
            if (!query.getStoredQueryPath().equals(queryPath)) continue;
            return query;
        }
        return null;
    }

    @Override
    public void removeSharedQuery(String queryName, SessionProvider provider) throws Exception {
        Session session = this.getSession(provider, true);
        session.getItem(this.baseQueriesPath_ + "/" + queryName).remove();
        session.save();
    }

    @Override
    public QueryResult execute(String queryPath, String workspace, SessionProvider provider, String userId) throws Exception {
        Session session = this.getSession(provider, true);
        Session querySession = this.getSession(workspace, provider);
        Node queryNode = null;
        try {
            queryNode = (Node)session.getItem(queryPath);
        }
        catch (PathNotFoundException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Can not find node by path " + queryPath + " in dms-system workspace"));
            }
            queryNode = (Node)querySession.getItem(queryPath);
        }
        if (queryNode != null && queryNode.hasProperty("exo:cachedResult") && queryNode.getProperty("exo:cachedResult").getBoolean()) {
            String portalName = this.containerInfo_.getContainerName();
            String key = portalName + queryPath;
            QueryResult result = (QueryResult)this.cache_.get((Serializable)((Object)key));
            if (result != null) {
                return result;
            }
            result = this.execute(querySession, queryNode, userId);
            this.cache_.put((Serializable)((Object)key), (Object)result);
            return result;
        }
        QueryResult queryResult = this.execute(querySession, queryNode, userId);
        return queryResult;
    }

    private QueryResult execute(Session session, Node queryNode, String userId) throws Exception {
        return this.createQuery(session, queryNode, userId).execute();
    }

    private String computeStatement(String statement, String userId) {
        String ret = statement;
        ret = ret.replace("${UserId}$", userId);
        String currentDate = ISO8601.format((Calendar)new GregorianCalendar());
        ret = ret.replace("${Date}$", currentDate);
        return ret;
    }

    private void removeFromCache(String queryPath) throws Exception {
        String portalName = this.containerInfo_.getContainerName();
        String key = portalName + queryPath;
        QueryResult result = (QueryResult)this.cache_.get((Serializable)((Object)key));
        if (result != null) {
            this.cache_.remove((Serializable)((Object)key));
        }
    }

    private Session getSession() throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
    }

    private Session getSession(SessionProvider provider, boolean flag) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        if (!flag) {
            String workspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
            return provider.getSession(workspace, manageableRepository);
        }
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return provider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
    }

    private Session getSession(String workspace, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        return provider.getSession(workspace, manageableRepository);
    }

    private boolean canUseQuery(String userId, Node queryNode) throws Exception {
        Value[] values;
        for (Value value : values = queryNode.getProperty("exo:accessPermissions").getValues()) {
            String accessPermission = value.getString();
            if (!this.hasMembership(userId, accessPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMembership(String userId, String roleExpression) {
        if (roleExpression.equals("*") || roleExpression.equals(IdentityConstants.ANY)) {
            return true;
        }
        String membershipType = roleExpression.substring(0, roleExpression.indexOf(":"));
        String groupName = roleExpression.substring(roleExpression.indexOf(":") + 1);
        try {
            MembershipHandler membershipHandler = this.organizationService_.getMembershipHandler();
            if ("*".equals(membershipType)) {
                return !membershipHandler.findMembershipsByUserAndGroup(userId, groupName).isEmpty();
            }
            return membershipHandler.findMembershipByUserGroupAndType(userId, groupName, membershipType) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Query getQuery(String queryPath, String workspace, SessionProvider provider, String userId) throws Exception {
        Session session = this.getSession(provider, true);
        Session querySession = this.getSession(workspace, provider);
        Node queryNode = null;
        try {
            queryNode = (Node)session.getItem(queryPath);
        }
        catch (PathNotFoundException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Can not find node by path " + queryPath + " in dms-system workspace"));
            }
            queryNode = (Node)querySession.getItem(queryPath);
        }
        return this.createQuery(querySession, queryNode, userId);
    }

    private Query createQuery(Session session, Node queryNode, String userId) throws Exception {
        String statement = this.computeStatement(queryNode.getProperty("jcr:statement").getString(), userId);
        String language = queryNode.getProperty("jcr:language").getString();
        Query query = session.getWorkspace().getQueryManager().createQuery(statement, language);
        return query;
    }

    @Override
    public Set<String> getAllConfiguredQueries() {
        return this.configuredQueries_;
    }
}

