/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import java.util.Arrays;
import java.util.Comparator;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;

public class NodeDefinitionData
extends ItemDefinitionData {
    protected final InternalQName[] requiredPrimaryTypes;
    protected final InternalQName defaultPrimaryType;
    protected final boolean allowsSameNameSiblings;

    public NodeDefinitionData(InternalQName name, InternalQName declaringNodeType, boolean autoCreated, boolean mandatory, int onParentVersion, boolean protectedItem, InternalQName[] requiredPrimaryTypes, InternalQName defaultPrimaryType, boolean allowsSameNameSiblings) {
        super(name, declaringNodeType, autoCreated, mandatory, onParentVersion, protectedItem);
        this.requiredPrimaryTypes = requiredPrimaryTypes;
        this.defaultPrimaryType = defaultPrimaryType;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
        Arrays.sort(requiredPrimaryTypes, new Comparator<InternalQName>(){

            @Override
            public int compare(InternalQName o1, InternalQName o2) {
                return o1.getAsString().compareTo(o2.getAsString());
            }
        });
    }

    public InternalQName[] getRequiredPrimaryTypes() {
        return this.requiredPrimaryTypes;
    }

    public InternalQName getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowsSameNameSiblings ? 1231 : 1237);
        result = 31 * result + (this.defaultPrimaryType == null ? 0 : this.defaultPrimaryType.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.requiredPrimaryTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NodeDefinitionData)) {
            return false;
        }
        NodeDefinitionData other = (NodeDefinitionData)obj;
        if (this.allowsSameNameSiblings != other.allowsSameNameSiblings) {
            return false;
        }
        if (this.defaultPrimaryType == null ? other.defaultPrimaryType != null : !this.defaultPrimaryType.equals((Object)other.defaultPrimaryType)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.requiredPrimaryTypes, (Object[])other.requiredPrimaryTypes);
    }

    public boolean isAllowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    public boolean isNodeDefinition() {
        return true;
    }
}

