/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanerTool;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScriptsFactory;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBCleanService {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanService");

    /*
     * Loose catch block
     */
    public static void cleanWorkspaceData(WorkspaceEntry wsEntry) throws DBCleanException {
        block7: {
            SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
            Connection jdbcConn = DBCleanService.getConnection(wsEntry);
            String dialect = DBCleanService.resolveDialect(jdbcConn, wsEntry);
            boolean autoCommit = dialect.startsWith("SYBASE");
            jdbcConn.setAutoCommit(autoCommit);
            DBCleanerTool dbCleaner = DBCleanService.getWorkspaceDBCleaner(jdbcConn, wsEntry);
            DBCleanService.doClean(dbCleaner);
            Object var6_6 = null;
            try {
                jdbcConn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Can not close connection", (Throwable)e);
            }
            break block7;
            {
                catch (SQLException e) {
                    throw new DBCleanException(e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    jdbcConn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can not close connection", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void cleanRepositoryData(RepositoryEntry rEntry) throws DBCleanException {
        block10: {
            Connection jdbcConn;
            SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
            WorkspaceEntry wsEntry = rEntry.getWorkspaceEntries().get(0);
            boolean multiDB = DBCleanService.getMultiDbParameter(wsEntry);
            if (multiDB) {
                for (WorkspaceEntry entry : rEntry.getWorkspaceEntries()) {
                    DBCleanService.cleanWorkspaceData(entry);
                }
            } else {
                jdbcConn = DBCleanService.getConnection(wsEntry);
                String dialect = DBCleanService.resolveDialect(jdbcConn, wsEntry);
                boolean autoCommit = dialect.startsWith("SYBASE");
                jdbcConn.setAutoCommit(autoCommit);
                DBCleanerTool dbCleaner = DBCleanService.getRepositoryDBCleaner(jdbcConn, rEntry);
                DBCleanService.doClean(dbCleaner);
                Object var8_10 = null;
                try {
                    jdbcConn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can not close connection", (Throwable)e);
                }
            }
            break block10;
            {
                catch (SQLException e) {
                    throw new DBCleanException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    jdbcConn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can not close connection", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public static DBCleanerTool getRepositoryDBCleaner(Connection jdbcConn, RepositoryEntry rEntry) throws DBCleanException {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        WorkspaceEntry wsEntry = rEntry.getWorkspaceEntries().get(0);
        boolean multiDb = DBCleanService.getMultiDbParameter(wsEntry);
        if (multiDb) {
            throw new DBCleanException("It is not possible to create cleaner with common connection for multi database repository configuration");
        }
        String dialect = DBCleanService.resolveDialect(jdbcConn, wsEntry);
        boolean autoCommit = dialect.startsWith("SYBASE");
        DBCleaningScripts scripts = DBCleaningScriptsFactory.prepareScripts(dialect, rEntry);
        return new DBCleanerTool(jdbcConn, autoCommit, scripts.getCleaningScripts(), scripts.getCommittingScripts(), scripts.getRollbackingScripts());
    }

    public static DBCleanerTool getWorkspaceDBCleaner(Connection jdbcConn, WorkspaceEntry wsEntry) throws DBCleanException {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        String dialect = DBCleanService.resolveDialect(jdbcConn, wsEntry);
        boolean autoCommit = dialect.startsWith("SYBASE");
        DBCleaningScripts scripts = DBCleaningScriptsFactory.prepareScripts(dialect, wsEntry);
        return new DBCleanerTool(jdbcConn, autoCommit, scripts.getCleaningScripts(), scripts.getCommittingScripts(), scripts.getRollbackingScripts());
    }

    private static void doClean(DBCleanerTool dbCleaner) throws DBCleanException, SQLException {
        Connection jdbcConn = dbCleaner.getConnection();
        try {
            dbCleaner.clean();
            dbCleaner.commit();
            jdbcConn.commit();
        }
        catch (SQLException e) {
            jdbcConn.rollback();
            dbCleaner.rollback();
            jdbcConn.commit();
        }
    }

    private static Connection getConnection(WorkspaceEntry wsEntry) throws DBCleanException {
        Connection jdbcConn;
        DataSource ds;
        String dsName = DBCleanService.getSourceNameParameter(wsEntry);
        try {
            ds = (DataSource)new InitialContext().lookup(dsName);
        }
        catch (NamingException e) {
            throw new DBCleanException(e);
        }
        if (ds == null) {
            throw new DBCleanException("Data source " + dsName + " not found");
        }
        final DataSource dsF = ds;
        try {
            jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return dsF.getConnection();
                }
            });
        }
        catch (SQLException e) {
            throw new DBCleanException(e);
        }
        return jdbcConn;
    }

    private static String getSourceNameParameter(WorkspaceEntry wsEntry) throws DBCleanException {
        try {
            return wsEntry.getContainer().getParameterValue("source-name");
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
    }

    private static boolean getMultiDbParameter(WorkspaceEntry wsEntry) throws DBCleanException {
        try {
            return DBInitializerHelper.getDatabaseType(wsEntry).isMultiDatabase();
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
    }

    private static String resolveDialect(Connection jdbcConn, WorkspaceEntry wsEntry) throws DBCleanException {
        String dialect = DBInitializerHelper.getDatabaseDialect(wsEntry);
        if (dialect.startsWith("AUTO")) {
            try {
                dialect = DialectDetecter.detect((DatabaseMetaData)jdbcConn.getMetaData());
            }
            catch (SQLException e) {
                throw new DBCleanException(e);
            }
        }
        return dialect;
    }
}

