/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.importer.ImportMode;

public class PortalConfigImporter {
    private final PortalConfig src;
    private final DataStorage service;
    private final ImportMode mode;

    public PortalConfigImporter(ImportMode importMode, PortalConfig portal, DataStorage dataStorage_) {
        this.mode = importMode;
        this.src = portal;
        this.service = dataStorage_;
    }

    public void perform() throws Exception {
        PortalConfig existingPortalConfig = this.service.getPortalConfig(this.src.getType(), this.src.getName());
        PortalConfig dst = null;
        switch (this.mode) {
            case CONSERVE: {
                dst = null;
                break;
            }
            case INSERT: {
                if (existingPortalConfig == null) {
                    dst = this.src;
                    break;
                }
                dst = null;
                break;
            }
            case MERGE: 
            case OVERWRITE: {
                dst = this.src;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (dst != null) {
            if (existingPortalConfig == null) {
                this.service.create(dst);
            } else {
                this.service.save(dst);
            }
        }
    }
}

