/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public final class MediaDataBox
extends AbstractBox {
    public static final String TYPE = "mdat";
    private boolean smallBox = false;
    private byte[] deadBytesBefore = new byte[0];
    private IsoBufferWrapper isoBufferWrapper;

    public MediaDataBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public byte[] getDeadBytesBefore() {
        return this.deadBytesBefore;
    }

    protected long getHeaderSize() {
        return 8 + (this.smallBox ? 0 : 8);
    }

    public void getBox(IsoOutputStream os) throws IOException {
        os.write(this.getHeader());
        os.write(this.getDeadBytesBefore());
        this.getContent(os);
        if (this.deadBytes != null) {
            this.deadBytes.position(0L);
            while (this.deadBytes.remaining() > 0L) {
                os.write(this.deadBytes.readByte());
            }
        }
    }

    public long getSize() {
        long contentSize = this.getContentSize();
        long headerSize = this.getHeaderSize();
        return headerSize + contentSize + (this.deadBytes == null ? 0L : this.deadBytes.size()) + (long)this.getDeadBytesBefore().length;
    }

    protected long getContentSize() {
        return this.isoBufferWrapper.size();
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long start = in.position();
        this.smallBox = start - this.offset <= 8L;
        this.isoBufferWrapper = in.getSegment(start, size);
        in.position(start);
        in.skip(size);
    }

    protected boolean isSmallBox() {
        return this.smallBox;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        this.isoBufferWrapper.position(0L);
        while (this.isoBufferWrapper.remaining() > 1024L) {
            byte[] buf = new byte[1024];
            this.isoBufferWrapper.read(buf);
            os.write(buf);
        }
        while (this.isoBufferWrapper.remaining() > 0L) {
            os.write(this.isoBufferWrapper.readByte());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaDataBox");
        sb.append("{offset=").append(this.getOffset());
        sb.append(", size=").append(this.getSize());
        sb.append('}');
        return sb.toString();
    }
}

