/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmRightsObjectBox
extends AbstractFullBox {
    public static final String TYPE = "odrb";
    private byte[] rightsObject;

    public OmaDrmRightsObjectBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public byte[] getRightsObject() {
        return this.rightsObject;
    }

    protected long getContentSize() {
        return this.rightsObject.length;
    }

    public void setRightsObject(byte[] rightsObject) {
        this.rightsObject = rightsObject;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.rightsObject = in.read((int)size - 4);
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(this.rightsObject);
    }

    public String toString() {
        return "OmaDrmRightsObjectBox[rightsObject=" + this.getRightsObject() + "]";
    }
}

