/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;

public class AudioSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "samr";
    public static final String TYPE2 = "sawb";
    public static final String TYPE3 = "mp4a";
    public static final String TYPE4 = "drms";
    public static final String TYPE5 = "alac";
    public static final String TYPE7 = "owma";
    public static final String TYPE8 = "ac-3";
    public static final String TYPE_ENCRYPTED = "enca";
    private int channelCount;
    private int sampleSize;
    private long sampleRate;
    private int soundVersion;
    private int compressionId;
    private int packetSize;
    private long samplesPerPacket;
    private long bytesPerPacket;
    private long bytesPerFrame;
    private long bytesPerSample;
    private int reserved1;
    private long reserved2;
    private byte[] soundVersion2Data;

    public AudioSampleEntry(byte[] type) {
        super(type);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getSoundVersion() {
        return this.soundVersion;
    }

    public int getCompressionId() {
        return this.compressionId;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public long getSamplesPerPacket() {
        return this.samplesPerPacket;
    }

    public long getBytesPerPacket() {
        return this.bytesPerPacket;
    }

    public long getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public long getBytesPerSample() {
        return this.bytesPerSample;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.soundVersion = in.readUInt16();
        this.reserved1 = in.readUInt16();
        this.reserved2 = in.readUInt32();
        this.channelCount = in.readUInt16();
        this.sampleSize = in.readUInt16();
        this.compressionId = in.readUInt16();
        this.packetSize = in.readUInt16();
        this.sampleRate = in.readUInt32() >>> 16;
        if (this.soundVersion > 0) {
            this.samplesPerPacket = in.readUInt32();
            this.bytesPerPacket = in.readUInt32();
            this.bytesPerFrame = in.readUInt32();
            this.bytesPerSample = in.readUInt32();
            size -= 16L;
        }
        if (this.soundVersion == 2) {
            this.soundVersion2Data = in.read(20);
            size -= 20L;
        }
        size -= 28L;
        while (size > 8L && !TYPE7.equals(IsoFile.bytesToFourCC(this.type))) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(b);
            size -= b.getSize();
        }
    }

    protected long getContentSize() {
        long contentSize = 28L;
        contentSize += this.soundVersion > 0 ? 16L : 0L;
        contentSize += this.soundVersion == 2 ? 20L : 0L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public String toString() {
        return "AudioSampleEntry";
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt16(this.soundVersion);
        isos.writeUInt16(this.reserved1);
        isos.writeUInt32(this.reserved2);
        isos.writeUInt16(this.getChannelCount());
        isos.writeUInt16(this.getSampleSize());
        isos.writeUInt16(0);
        isos.writeUInt16(0);
        isos.writeUInt32(this.getSampleRate() << 16);
        if (this.soundVersion > 0) {
            isos.writeUInt32(this.samplesPerPacket);
            isos.writeUInt32(this.bytesPerPacket);
            isos.writeUInt32(this.bytesPerFrame);
            isos.writeUInt32(this.bytesPerSample);
        }
        if (this.soundVersion == 2) {
            isos.write(this.soundVersion2Data);
        }
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

