/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.model;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.h264.model.NALUnitType;
import java.io.IOException;
import java.io.OutputStream;

public class NALUnit {
    public NALUnitType type;
    public int nal_ref_idc;

    public NALUnit(NALUnitType type, int nal_ref_idc) {
        this.type = type;
        this.nal_ref_idc = nal_ref_idc;
    }

    public static NALUnit read(IsoBufferWrapper is) throws IOException {
        int nalu = is.read();
        int nal_ref_idc = nalu >> 5 & 3;
        int nb = nalu & 0x1F;
        NALUnitType type = NALUnitType.fromValue(nb);
        return new NALUnit(type, nal_ref_idc);
    }

    public void write(OutputStream out) throws IOException {
        int nalu = this.type.getValue() | this.nal_ref_idc << 5;
        out.write(nalu);
    }

    public String toString() {
        return "NALUnit{type=" + this.type + ", nal_ref_idc=" + this.nal_ref_idc + '}';
    }
}

