/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.LinkedList;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.impl.AbstractEventListAccess;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventRowListAccess
extends AbstractEventListAccess<Row> {
    private static Log log = ExoLogger.getLogger(EventRowListAccess.class);

    public EventRowListAccess(EventDAOImpl evtDAO, EventQuery eventQuery) {
        super(evtDAO, eventQuery);
    }

    public Row[] load(int offset, int limit) {
        try {
            QueryResultImpl queryResult = super.loadData(offset, limit);
            if (queryResult != null) {
                RowIterator rows = queryResult.getRows();
                LinkedList<Row> results = new LinkedList<Row>();
                while (rows.hasNext()) {
                    results.add(rows.nextRow());
                }
                return results.toArray(new Row[results.size()]);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

