/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;

public class DB2MYSSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public DB2MYSSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID LIMIT ?,?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.containerConfig.containerName);
        this.findNodesAndProperties.setString(2, this.getInternalId(lastNodeId));
        this.findNodesAndProperties.setInt(3, offset);
        this.findNodesAndProperties.setInt(4, limit);
        this.findNodesAndProperties.setString(5, this.containerConfig.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    protected void startTxIfNeeded() throws SQLException {
        if (this.containerConfig.isManaged && this.dbConnection.getAutoCommit()) {
            this.dbConnection.setAutoCommit(false);
        }
    }
}

