/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.localization.HttpRequestWrapper;
import org.exoplatform.portal.application.localization.LocalizationLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class LocalizationFilter
extends AbstractFilter {
    private static Log log = ExoLogger.getLogger((String)"portal:LocalizationFilter");
    private static ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private Locale portalLocale = Locale.ENGLISH;

    protected void afterInit(FilterConfig config) throws ServletException {
        String locale = config.getInitParameter("PortalLocale");
        String string = locale = locale != null ? locale.trim() : null;
        if (locale != null && locale.length() > 0) {
            this.portalLocale = LocaleContextInfo.getLocale((String)locale);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            PortalRequestContext context = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
            if (context != null && context.getLocale() != null) {
                boolean skipWrapping = currentLocale.get() != null;
                currentLocale.set(context.getLocale());
                if (!skipWrapping) {
                    req = new HttpRequestWrapper((HttpServletRequest)req);
                }
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            if (currentLocale.get() != null) {
                chain.doFilter(request, response);
                return;
            }
            ExoContainer container = this.getContainer();
            if (container == null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            LocaleConfigService localeConfigService = (LocaleConfigService)container.getComponentInstanceOfType(LocaleConfigService.class);
            LocalePolicy localePolicy = (LocalePolicy)container.getComponentInstanceOfType(LocalePolicy.class);
            LocaleContextInfo localeCtx = new LocaleContextInfo();
            HashSet<Locale> supportedLocales = new HashSet<Locale>();
            for (LocaleConfig lc : localeConfigService.getLocalConfigs()) {
                supportedLocales.add(lc.getLocale());
            }
            localeCtx.setSupportedLocales(supportedLocales);
            localeCtx.setBrowserLocales(Collections.list(request.getLocales()));
            localeCtx.setCookieLocales(LocalizationLifecycle.getCookieLocales(req));
            localeCtx.setSessionLocale(LocalizationLifecycle.getSessionLocale(req));
            localeCtx.setUserProfileLocale(this.getUserProfileLocale(container, req.getRemoteUser()));
            localeCtx.setRemoteUser(req.getRemoteUser());
            localeCtx.setPortalLocale(this.checkPortalLocaleSupported(this.portalLocale, supportedLocales));
            Locale locale = localePolicy.determineLocale(localeCtx);
            boolean supported = supportedLocales.contains(locale);
            if (!supported && !"".equals(locale.getCountry())) {
                locale = new Locale(locale.getLanguage());
                supported = supportedLocales.contains(locale);
            }
            if (!supported) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
                }
                locale = Locale.ENGLISH;
            }
            currentLocale.set(locale);
            chain.doFilter((ServletRequest)new HttpRequestWrapper((HttpServletRequest)req), (ServletResponse)res);
        }
        catch (Exception e) {
            throw new RuntimeException("LocalizationFilter exception: ", e);
        }
        finally {
            currentLocale.remove();
        }
    }

    private Locale checkPortalLocaleSupported(Locale portalLocale, Set<Locale> supportedLocales) {
        Locale loc;
        if (supportedLocales.contains(portalLocale)) {
            return portalLocale;
        }
        if (!"".equals(portalLocale.getCountry()) && supportedLocales.contains(loc = new Locale(portalLocale.getLanguage()))) {
            log.warn((Object)("portalLocale not supported: " + LocaleContextInfo.getLocaleAsString((Locale)portalLocale) + ". Falling back to '" + portalLocale.getLanguage() + "'."));
            this.portalLocale = loc;
            return loc;
        }
        log.warn((Object)("portalLocale not supported: " + LocaleContextInfo.getLocaleAsString((Locale)portalLocale) + ". Falling back to Locale.ENGLISH."));
        this.portalLocale = Locale.ENGLISH;
        return portalLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locale getUserProfileLocale(ExoContainer container, String user) {
        UserProfile userProfile = null;
        OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        if (user != null) {
            try {
                this.beginContext(svc);
                userProfile = svc.getUserProfileHandler().findUserProfileByName(user);
            }
            catch (Exception ignored) {
                log.error((Object)("IGNORED: Failed to load UserProfile for username: " + user), (Throwable)ignored);
            }
            finally {
                try {
                    this.endContext(svc);
                }
                catch (Exception ignored) {}
            }
            if (userProfile == null && log.isWarnEnabled()) {
                log.warn((Object)("Could not load user profile for " + user));
            }
        }
        String lang = userProfile == null ? null : (String)userProfile.getUserInfoMap().get("user.language");
        return lang != null ? LocaleContextInfo.getLocale((String)lang) : null;
    }

    public void beginContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void endContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }

    public void destroy() {
    }

    public static Locale getCurrentLocale() {
        return currentLocale.get();
    }
}

