/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.io.Writer;
import java.util.ResourceBundle;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.connections.UIAllPeople;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIUpdateRelationship
extends UIContainer {
    private Identity identity = null;
    private Relationship relationship;

    public UIUpdateRelationship setIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public UIUpdateRelationship setRelationship(Relationship relationship) {
        this.relationship = relationship;
        return this;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getTemplate() != null) {
            super.processRender(context);
            return;
        }
        Writer writer = context.getWriter();
        writer.append("<div id=\"").append(this.getId()).append("\">");
        if (this.identity != null) {
            Relationship.Type status;
            ResourceBundle res = context.getApplicationResourceBundle();
            UIAllPeople uiAllPeople = (UIAllPeople)this.getAncestorOfType(UIAllPeople.class);
            String label = res.getString("UIAllPeople.label.Ignore");
            String action = uiAllPeople.event("Ignore", this.identity.getId());
            String statusLabel = "";
            String statusClass = "";
            String btClass = "";
            Relationship.Type type = status = this.relationship != null ? this.relationship.getStatus() : null;
            if (status == null) {
                label = res.getString("UIAllPeople.label.Connect");
                action = uiAllPeople.event("Connect", this.identity.getId());
                btClass = "btn-primary";
            } else if (status.equals((Object)Relationship.Type.PENDING)) {
                label = res.getString("UIAllPeople.label.CancelRequest");
                statusLabel = res.getString("UIAllPeople.label.InvitationSent");
            } else if (status == Relationship.Type.CONFIRMED) {
                label = res.getString("UIAllPeople.label.RemoveConnection");
                statusClass = "checkedBox";
            }
            writer.append("<div style=\"display:none\" data-action=\"").append(action).append("\" ").append("data-status=\"").append(statusLabel).append("\" ").append("data-class=\"").append(statusClass).append("\" ").append("data-bt-class=\"").append(btClass).append("\">").append(label).append("</div>");
            context.getJavascriptManager().getRequireJS().require("SHARED/socialUtil", "utils").addScripts("utils.updateRelationship('" + this.identity.getId() + "' );");
        }
        this.identity = null;
        writer.append("</div>");
    }
}

