/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import java.util.Queue;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.BatchArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesSessionExtension
implements ServerSession.Extension,
ServerSession.DeQueueListener,
ServerSession.QueueListener {
    private static final Logger _logger = LoggerFactory.getLogger(AcknowledgedMessagesSessionExtension.class);
    private final ServerSessionImpl _session;
    private final BatchArrayQueue<ServerMessage> _queue;
    private final ThreadLocal<Long> _batch = new ThreadLocal();
    private long _lastBatch;

    public AcknowledgedMessagesSessionExtension(ServerSession session) {
        this._session = (ServerSessionImpl)session;
        this._queue = new BatchArrayQueue(16, this._session.getLock());
        this._session.setMetaConnectDeliveryOnly(true);
        this._session.addListener((ServerSession.ServerSessionListener)this);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
        Number batchValue;
        Map ext;
        if ("/meta/connect".equals(message.getChannel()) && (ext = message.getExt(false)) != null && (batchValue = (Number)ext.get("ack")) != null) {
            this.processBatch(batchValue.longValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBatch(long batch) {
        Object object = this._session.getLock();
        synchronized (object) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Processing batch: last={}, client={}, server={} for {}", new Object[]{this._lastBatch, batch, this._queue.getBatch(), this._session});
            }
            this._lastBatch = batch;
            this._queue.clearToBatch(batch);
        }
    }

    public ServerMessage send(ServerSession session, ServerMessage message) {
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queued(ServerSession sender, ServerMessage message) {
        Object object = this._session.getLock();
        synchronized (object) {
            this._queue.offer(message);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Stored at batch {} {} for {}", new Object[]{this._queue.getBatch(), message, this._session});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        if (message.getChannel().equals("/meta/connect")) {
            Object object = this._session.getLock();
            synchronized (object) {
                Map ext = message.getExt(true);
                long batch = this._queue.getBatch();
                this._batch.set(batch);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Sending batch {} for {}", (Object)batch, (Object)this._session);
                }
                ext.put("ack", batch);
                this._queue.nextBatch();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deQueue(ServerSession session, Queue<ServerMessage> queue) {
        Object object = this._session.getLock();
        synchronized (object) {
            long batch = this._batch.get();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Dequeuing {}/{} messages until batch {} for {}", new Object[]{queue.size(), this._queue.size(), batch, this._session});
            }
            queue.clear();
            this._queue.exportMessagesToBatch(queue, batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importMessages(ServerSessionImpl session) {
        Object object = this._session.getLock();
        synchronized (object) {
            this._queue.addAll(session.getQueue());
        }
    }
}

