/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import org.python.core.PySystemState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum OS {
    NT("Windows", (String[][])new String[][]{{"cmd.exe", "/c"}, {"command.com", "/c"}}),
    IBMi("OS/400", (String[][])new String[][]{{"/QOpenSys/usr/bin/sh", "-c"}}),
    POSIX(new String[][]{{"/bin/sh", "-c"}});

    private final String[][] shellCommands;
    private final String pattern;

    private OS(String pattern, String[] ... shellCommands) {
        this.shellCommands = shellCommands;
        this.pattern = pattern != null ? pattern : this.name();
    }

    private OS(String[] ... shellCommands) {
        this((String)null, shellCommands);
    }

    String getModuleName() {
        return this.name().toLowerCase();
    }

    String[][] getShellCommands() {
        return this.shellCommands;
    }

    static OS getOS() {
        String osName = PySystemState.registry.getProperty("python.os");
        if (osName == null) {
            osName = System.getProperty("os.name");
        }
        for (OS os2 : OS.values()) {
            if (!osName.startsWith(os2.pattern)) continue;
            return os2;
        }
        return POSIX;
    }
}

