/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.inject.Qualifier;
import juzu.Scope;
import juzu.impl.common.AnnotationLiteral;

abstract class AbstractBean
implements Bean {
    static final Annotation DEFAULT_QUALIFIER = new AnnotationLiteral<Default>(){};
    static final Annotation ANY_QUALIFIER = new AnnotationLiteral<Any>(){};
    protected final Class<?> type;
    protected final Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private final Set<Type> types;
    protected BeanManager manager;
    private String name;

    AbstractBean(Class<?> type, Scope scope, Iterable<Annotation> qualifiers) {
        HashSet<Type> types = new HashSet<Type>();
        this.collectSuperTypes(type, types);
        Class<? extends Annotation> scopeAnnotation = null;
        if (scope != null) {
            scopeAnnotation = scope.getAnnotationType();
        } else {
            for (Annotation annotation : type.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.getAnnotation(javax.inject.Scope.class) == null) continue;
                scopeAnnotation = annotationType;
                break;
            }
            if (scopeAnnotation == null) {
                scopeAnnotation = Dependent.class;
            }
        }
        HashMap<Class<Annotation>, Annotation> qualifierMap = new HashMap<Class<Annotation>, Annotation>();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                qualifierMap.put(qualifier.annotationType(), qualifier);
            }
        } else {
            for (Annotation annotation : type.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(Qualifier.class) == null) continue;
                qualifierMap.put(annotation.annotationType(), annotation);
            }
        }
        qualifierMap.put(Default.class, DEFAULT_QUALIFIER);
        qualifierMap.put(Any.class, ANY_QUALIFIER);
        String name = null;
        Annotation named = (Annotation)qualifierMap.get(Named.class);
        if (named != null) {
            name = ((Named)named).value();
        }
        this.type = type;
        this.types = types;
        this.qualifiers = Collections.unmodifiableSet(new HashSet(qualifierMap.values()));
        this.name = name;
        this.scope = scopeAnnotation;
    }

    private void collectSuperTypes(Class<?> type, HashSet<Type> superTypes) {
        superTypes.add(type);
        Class<?> superClassType = type.getSuperclass();
        if (superClassType != null) {
            this.collectSuperTypes(superClassType, superTypes);
        }
        for (Class<?> interfaceType : type.getInterfaces()) {
            this.collectSuperTypes(interfaceType, superTypes);
        }
    }

    void register(BeanManager manager) {
        this.manager = manager;
    }

    public final Set<Type> getTypes() {
        return this.types;
    }

    public final Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public final Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public final Class<?> getBeanClass() {
        return this.type;
    }

    public final boolean isAlternative() {
        return false;
    }

    public final boolean isNullable() {
        return false;
    }

    public final Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String toString() {
        return "Bean[type=" + this.type.getName() + ",name=" + this.name + ",qualifiers=" + this.qualifiers + "]";
    }
}

