/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi.weld;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import juzu.Handler;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.CDIInjector;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;

public class WeldInjector
extends CDIInjector {
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems;

    public WeldInjector() {
        this.classLoader = null;
        this.fileSystems = new ArrayList();
    }

    public WeldInjector(WeldInjector that) {
        super(that);
        this.classLoader = that.classLoader;
        this.fileSystems = new ArrayList(that.fileSystems);
    }

    @Override
    public boolean isProvided() {
        return false;
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InjectionContext<?, ?> create(Handler<Class<?>, Boolean> filter) throws Exception {
        final WeldContainer container = new WeldContainer(this.classLoader, this.scopeController, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        CDIContext cdiContext = new CDIContext(this, filter){

            @Override
            public ClassLoader getClassLoader() {
                return container.getClassLoader();
            }

            @Override
            public BeanManager getBeanManager() {
                return container.getManager();
            }

            @Override
            public void close() {
                container.stop();
            }

            @Override
            public InjectorProvider getProvider() {
                return InjectorProvider.WELD;
            }
        };
        CDIContext.boot.set(cdiContext);
        try {
            container.start();
        }
        finally {
            CDIContext.boot.set(cdiContext);
        }
        return cdiContext;
    }

    @Override
    public Injector get() {
        return new WeldInjector(this);
    }
}

