/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.mozilla.rhino;

import com.google.javascript.jscomp.mozilla.rhino.BaseFunction;
import com.google.javascript.jscomp.mozilla.rhino.Callable;
import com.google.javascript.jscomp.mozilla.rhino.Context;
import com.google.javascript.jscomp.mozilla.rhino.Function;
import com.google.javascript.jscomp.mozilla.rhino.NativeObject;
import com.google.javascript.jscomp.mozilla.rhino.ScriptRuntime;
import com.google.javascript.jscomp.mozilla.rhino.Scriptable;

public class BoundFunction
extends BaseFunction {
    private final Callable targetFunction;
    private final Scriptable boundThis;
    private final Object[] boundArgs;
    private final int length;

    public BoundFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis, Object[] boundArgs) {
        this.targetFunction = targetFunction;
        this.boundThis = boundThis;
        this.boundArgs = boundArgs;
        this.length = targetFunction instanceof BaseFunction ? Math.max(0, ((BaseFunction)targetFunction).getLength() - boundArgs.length) : 0;
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
        BaseFunction thrower = ScriptRuntime.typeErrorThrower();
        NativeObject throwing = new NativeObject();
        throwing.put("get", (Scriptable)throwing, (Object)thrower);
        throwing.put("set", (Scriptable)throwing, (Object)thrower);
        throwing.put("enumerable", (Scriptable)throwing, (Object)false);
        throwing.put("configurable", (Scriptable)throwing, (Object)false);
        throwing.preventExtensions();
        this.defineOwnProperty(cx, "caller", throwing);
        this.defineOwnProperty(cx, "arguments", throwing);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] extraArgs) {
        return this.targetFunction.call(cx, scope, this.boundThis, this.concat(this.boundArgs, extraArgs));
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] extraArgs) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).construct(cx, scope, this.concat(this.boundArgs, extraArgs));
        }
        throw ScriptRuntime.typeError0("msg.not.ctor");
    }

    public boolean hasInstance(Scriptable instance) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(instance);
        }
        throw ScriptRuntime.typeError0("msg.not.ctor");
    }

    public int getLength() {
        return this.length;
    }

    private Object[] concat(Object[] first, Object[] second) {
        Object[] args = new Object[first.length + second.length];
        System.arraycopy(first, 0, args, 0, first.length);
        System.arraycopy(second, 0, args, first.length, second.length);
        return args;
    }
}

