/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.http;

import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.text.CharBuffer;
import org.gatein.common.text.CharEncoder;
import org.gatein.common.text.CharWriter;
import org.gatein.common.text.EncodingException;
import org.gatein.common.text.FastURLDecoder;
import org.gatein.common.util.ParameterMap;

public class QueryStringParser {
    private static QueryStringParser DEFAULT_PARSER = new QueryStringParser();
    private static final Logger log = LoggerFactory.getLogger(QueryStringParser.class);
    private static final int LOOKUP = 0;
    private static final int INVALID_CHUNK = 1;
    private static final int PARAM_NAME = 2;
    private static final int PARAM_VALUE = 3;
    private CharEncoder parameterDecoder;

    public static QueryStringParser getInstance() {
        return DEFAULT_PARSER;
    }

    public QueryStringParser(CharEncoder parameterDecoder) throws IllegalArgumentException {
        if (parameterDecoder == null) {
            throw new IllegalArgumentException("No parameter decoder");
        }
        this.parameterDecoder = parameterDecoder;
    }

    public QueryStringParser() {
        this(FastURLDecoder.getUTF8Instance());
    }

    public CharEncoder getParameterDecoder() {
        return this.parameterDecoder;
    }

    private void append(ParameterMap parameterMap, String parameterName, String parameterValue) {
        String[] values = parameterMap.getValues(parameterName);
        if (values == null) {
            values = new String[]{parameterValue};
        } else {
            String[] tmp = new String[values.length + 1];
            System.arraycopy(values, 0, tmp, 0, values.length);
            values = tmp;
            values[values.length - 1] = parameterValue;
        }
        parameterMap.setValues(parameterName, values);
    }

    public ParameterMap parseQueryString(String queryString) throws IllegalArgumentException {
        if (queryString == null) {
            throw new IllegalArgumentException();
        }
        ParameterMap parameterMap = new ParameterMap();
        String encodedName = null;
        CharBuffer buffer = new CharBuffer(50);
        int pos = 0;
        int len = queryString.length();
        int state = 0;
        block12: while (true) {
            char c;
            if (pos < len) {
                c = queryString.charAt(pos++);
            } else {
                if (pos != len) break;
                c = '&';
                ++pos;
            }
            switch (state) {
                case 0: {
                    if (c == '&') continue block12;
                    if (c == '=') {
                        state = 1;
                        break;
                    }
                    state = 2;
                    buffer.append(c);
                    break;
                }
                case 2: {
                    if (c == '&') {
                        String tmp = buffer.asString();
                        try {
                            this.parameterDecoder.encode(tmp, (CharWriter)buffer);
                            this.append(parameterMap, buffer.asString(false), "");
                        }
                        catch (EncodingException e) {
                            log.debug((Object)("Could not decode parameter name " + tmp), (Throwable)e);
                        }
                        buffer.reset();
                        state = 0;
                        break;
                    }
                    if (c == '=') {
                        encodedName = buffer.asString();
                        buffer.reset();
                        state = 3;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case 3: {
                    if (c == '&') {
                        try {
                            String encodedValue = buffer.asString();
                            this.parameterDecoder.encode(encodedName, (CharWriter)buffer);
                            String name = buffer.asString(false);
                            try {
                                buffer.reset();
                                this.parameterDecoder.encode(encodedValue, (CharWriter)buffer);
                                String value = buffer.asString();
                                this.append(parameterMap, name, value);
                            }
                            catch (EncodingException e) {
                                log.debug((Object)("Could not decode parameter value " + encodedValue), (Throwable)e);
                            }
                        }
                        catch (EncodingException e) {
                            log.debug((Object)("Could not decode parameter name " + encodedName), (Throwable)e);
                        }
                        buffer.reset();
                        state = 0;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case 1: {
                    if (c != 38) break;
                    state = 0;
                }
            }
        }
        return parameterMap;
    }
}

