/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.math.NumberUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.user.UserStateModel;

public class UserStateService {
    private static final Log LOG = ExoLogger.getLogger((String)UserStateService.class.getName());
    public static String VIDEOCALLS_BASE_PATH = "VideoCalls";
    public static String USER_STATATUS_NODETYPE = "exo:userState";
    public static String USER_ID_PROP = "exo:userId";
    public static String LAST_ACTIVITY_PROP = "exo:lastActivity";
    public static String STATUS_PROP = "exo:status";
    public static String DEFAULT_STATUS = "available";
    public static final int DEFAULT_OFFLINE_DELAY = 60000;
    public static final int DEFAULT_PING_FREQUENCY = 15000;
    public int delay = 60000;
    public static final int _delay_update_DB = 180000;
    public static int pingCounter = 0;
    private final CacheService cacheService;

    public UserStateService(CacheService cacheService) {
        this.cacheService = cacheService;
        String strDelay = System.getProperty("user.status.offline.delay");
        this.delay = NumberUtils.toInt((String)strDelay, (int)60000);
        this.delay = this.delay > 0 ? this.delay : 60000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(UserStateModel model) {
        String userId = model.getUserId();
        NodeHierarchyCreator nodeHierarchyCreator = CommonsUtils.getService(NodeHierarchyCreator.class);
        try (SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());){
            ManageableRepository repository = CommonsUtils.getRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            String repoName = repository.getConfiguration().getName();
            Node userNodeApp = nodeHierarchyCreator.getUserApplicationNode(sessionProvider, userId);
            String userKey = repoName + "_" + userId;
            Node userState = userNodeApp.hasNode(VIDEOCALLS_BASE_PATH) ? userNodeApp.getNode(VIDEOCALLS_BASE_PATH) : userNodeApp.addNode(VIDEOCALLS_BASE_PATH, USER_STATATUS_NODETYPE);
            userState.setProperty(USER_ID_PROP, userId);
            userState.setProperty(LAST_ACTIVITY_PROP, model.getLastActivity());
            userState.setProperty(STATUS_PROP, model.getStatus());
            session.save();
            ExoCache<Serializable, UserStateModel> cache = this.getUserStateCache();
            if (cache == null) {
                LOG.warn("Can't save user state of {} to cache", new Object[]{userId});
            } else {
                cache.put((Serializable)((Object)userKey), (Object)model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserStateModel getUserState(String userId) {
        UserStateModel model = null;
        String repoName = CommonsUtils.getRepository().getConfiguration().getName();
        String userKey = repoName + "_" + userId;
        ExoCache<Serializable, UserStateModel> userStateCache = this.getUserStateCache();
        if (userStateCache != null && userStateCache.get((Serializable)((Object)userKey)) != null) {
            model = ((UserStateModel)userStateCache.get((Serializable)((Object)userKey))).clone();
        } else {
            ConversationState state = ConversationState.getCurrent();
            if (state == null) {
                return null;
            }
            NodeHierarchyCreator nodeHierarchyCreator = CommonsUtils.getService(NodeHierarchyCreator.class);
            try (SessionProvider sessionProvider = new SessionProvider(state);){
                Node userNodeApp = nodeHierarchyCreator.getUserApplicationNode(sessionProvider, userId);
                Node userState = userNodeApp.getNode(VIDEOCALLS_BASE_PATH);
                model = new UserStateModel();
                model.setUserId(userState.getProperty(USER_ID_PROP).getString());
                model.setLastActivity(userState.getProperty(LAST_ACTIVITY_PROP).getLong());
                model.setStatus(userState.hasProperty(STATUS_PROP) ? userState.getProperty(STATUS_PROP).getString() : DEFAULT_STATUS);
                userStateCache.put((Serializable)((Object)userKey), (Object)model);
            }
        }
        return model;
    }

    public void ping(String userId) {
        boolean isSave;
        if (userId == null || IdentityConstants.ANONIM.equals(userId)) {
            return;
        }
        UserStateModel model = this.getUserState(userId);
        long lastActivity = Calendar.getInstance().getTimeInMillis();
        boolean bl = isSave = model == null || lastActivity - model.getLastActivity() > 180000L;
        if (model == null) {
            model = new UserStateModel(userId, lastActivity, DEFAULT_STATUS);
        } else {
            model.setLastActivity(lastActivity);
            String repoName = CommonsUtils.getRepository().getConfiguration().getName();
            String userKey = repoName + "_" + userId;
            this.getUserStateCache().put((Serializable)((Object)userKey), (Object)model);
        }
        if (isSave) {
            this.save(model);
        }
    }

    public List<UserStateModel> online() {
        ArrayList<UserStateModel> onlineUsers = new ArrayList<UserStateModel>();
        List users = null;
        try {
            ExoCache<Serializable, UserStateModel> userStateCache = this.getUserStateCache();
            if (userStateCache == null) {
                LOG.warn((Object)"Cant get online users list from cache. Will return an empty list.");
                return new ArrayList<UserStateModel>();
            }
            users = userStateCache.getCachedObjects();
            for (UserStateModel userStateModel : users) {
                if (!this.isOnline(userStateModel)) continue;
                onlineUsers.add(userStateModel);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when getting online user: {}", (Throwable)e);
        }
        return onlineUsers;
    }

    public boolean isOnline(String userId) {
        UserStateModel model = this.getUserState(userId);
        if (model != null) {
            return this.isOnline(model);
        }
        return false;
    }

    private boolean isOnline(UserStateModel model) {
        if (model != null) {
            long iDate = Calendar.getInstance().getTimeInMillis();
            if (model.getLastActivity() >= iDate - (long)this.delay) {
                return true;
            }
        }
        return false;
    }

    private ExoCache<Serializable, UserStateModel> getUserStateCache() {
        return this.cacheService.getCacheInstance(UserStateService.class.getName() + CommonsUtils.getRepository().getConfiguration().getName());
    }
}

