/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.PageListFactory;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.paginator.UILazyPageIterator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISearchResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={OpenFolderActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class})})
public class UISearchResult
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UISearchResult.class.getName());
    private QueryData queryData_;
    private long searchTime_ = 0L;
    private UIPageIterator uiPageIterator_;
    private static String iconType = "";
    private static String iconScore = "";
    private static int PAGE_SIZE = 10;
    private List<String> categoryPathList = new ArrayList<String>();
    private String constraintsCondition;
    private String workspaceName = null;
    private String currentPath = null;
    private String keyword = "";
    private AbstractPageList<RowData> pageList;

    public List<String> getCategoryPathList() {
        return this.categoryPathList;
    }

    public void setCategoryPathList(List<String> categoryPathListItem) {
        this.categoryPathList = categoryPathListItem;
    }

    public String getConstraintsCondition() {
        return this.constraintsCondition;
    }

    public void setConstraintsCondition(String constraintsConditionItem) {
        this.constraintsCondition = constraintsConditionItem;
    }

    public UISearchResult() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UILazyPageIterator.class, null, "UISearchResultPageIterator");
    }

    public void setQuery(String queryStatement, String workspaceName, String language, boolean isSystemSession, String keyword) {
        this.queryData_ = new QueryData(queryStatement, workspaceName, language, isSystemSession);
        this.keyword = keyword;
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public List getCurrentList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public Session getSession() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getTargetSession();
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public Node getNodeByPath(String path) throws Exception {
        try {
            JCRPath nodePath = ((SessionImpl)this.getSession()).getLocationFactory().parseJCRPath(path);
            return (Node)this.getSession().getItem(nodePath.getAsString(false));
        }
        catch (Exception e) {
            return null;
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid() throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        List documentList = templateService.getDocumentTemplates();
        this.pageList = PageListFactory.createPageList((String)this.queryData_.getQueryStatement(), (String)this.queryData_.getWorkSpace(), (String)this.queryData_.getLanguage_(), (boolean)this.queryData_.isSystemSession(), (NodeSearchFilter)new NodeFilter(this.categoryPathList, this.keyword, documentList), (SearchDataCreator)new RowDataCreator(), (int)PAGE_SIZE, (int)0);
        this.uiPageIterator_.setPageList(this.pageList);
    }

    public String StriptHTML(String s) {
        String[] targets;
        for (String target : targets = new String[]{"<div>", "</div>", "<span>", "</span>"}) {
            s = s.replace(target, "");
        }
        return s;
    }

    public static class RowData {
        private String jcrPath;
        private String repExcerpt;
        private long jcrScore;
        private String jcrPrimaryType;

        public RowData(Row row) {
            this(row, null);
        }

        public RowData(Row row, Node node) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            this.jcrPath = "";
                            this.repExcerpt = "";
                            this.jcrScore = 0L;
                            this.jcrPrimaryType = "";
                            try {
                                this.jcrPath = node != null ? node.getPath() : row.getValue("jcr:path").getString();
                            }
                            catch (Exception e) {
                                if (!LOG.isWarnEnabled()) break block8;
                                LOG.warn((Object)e.getMessage());
                            }
                        }
                        try {
                            this.repExcerpt = row.getValue("rep:excerpt(.)").getString();
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block9;
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                    try {
                        this.jcrScore = row.getValue("jcr:score").getLong();
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block10;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                try {
                    this.jcrPrimaryType = row.getValue("jcr:primaryType").getString();
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }

        public String getJcrPath() {
            return this.jcrPath;
        }

        public void setJcrPath(String jcrPath) {
            this.jcrPath = jcrPath;
        }

        public String getRepExcerpt() {
            return this.repExcerpt;
        }

        public void setRepExcerpt(String repExcerpt) {
            this.repExcerpt = repExcerpt;
        }

        public long getJcrScore() {
            return this.jcrScore;
        }

        public void setJcrScore(long jcrScore) {
            this.jcrScore = jcrScore;
        }

        public String getJcrPrimaryType() {
            return this.jcrPrimaryType;
        }

        public void setJcrPrimaryType(String value) {
            this.jcrPrimaryType = value;
        }

        public int hashCode() {
            return this.jcrPath == null ? 0 : this.jcrPath.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RowData)) {
                return false;
            }
            RowData data = (RowData)o;
            return this.jcrPath == null && data.jcrPath == null || this.jcrPath.equals(data.jcrPath);
        }
    }

    public static class RowDataCreator
    implements SearchDataCreator<RowData> {
        public RowData createData(Node node, Row row) {
            return new RowData(row, node);
        }
    }

    public static class NodeFilter
    implements NodeSearchFilter {
        private List<String> categoryPathList;
        private TaxonomyService taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        private NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        private String rootTreePath;
        private LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        private String keyword = "";
        private List<String> documentTypes;
        private static final String CHECK_LINK_MATCH_QUERY1 = "select * from nt:base where jcr:path = '$0' and ( contains(*, '$1') or lower(exo:name) like '%$2%' or lower(exo:title) like '%$2%')";
        private static final String CHECK_LINK_MATCH_QUERY2 = "select * from nt:base where jcr:path like '$0/%' and ( contains(*, '$1') or lower(exo:name) like '%$2%' or lower(exo:title) like '%$2%')";

        public NodeFilter(List<String> categories, String keyword, List<String> documentTypes) {
            this.rootTreePath = this.nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
            this.categoryPathList = categories;
            this.keyword = keyword;
            this.documentTypes = documentTypes;
        }

        public Node filterNodeToDisplay(Node node) {
            block12: {
                try {
                    if (node == null || node.getPath().contains("/jcr:system/")) {
                        return null;
                    }
                    if (node == null) break block12;
                    if (this.categoryPathList != null && this.categoryPathList.size() > 0) {
                        for (String categoryPath : this.categoryPathList) {
                            int index = categoryPath.indexOf("/");
                            String taxonomyName = categoryPath;
                            String postFixTaxonomy = "";
                            if (index > 0) {
                                taxonomyName = categoryPath.substring(0, index);
                                postFixTaxonomy = categoryPath.substring(index + 1);
                            }
                            ArrayList<String> pathCategoriesList = new ArrayList<String>();
                            String searchCategory = this.taxonomyService.getTaxonomyTree(taxonomyName).getPath() + ("".equals(postFixTaxonomy) ? "" : "/" + postFixTaxonomy);
                            Node targetNode = node.isNodeType("exo:symlink") ? this.linkManager.getTarget(node) : node;
                            List listCategories = this.taxonomyService.getCategories(targetNode, taxonomyName);
                            for (Node category : listCategories) {
                                pathCategoriesList.add(category.getPath());
                            }
                            if (!pathCategoriesList.contains(searchCategory)) continue;
                            if (node.isNodeType("exo:symlink")) {
                                if (!this.checkTargetMatch(node, this.keyword)) continue;
                                return node;
                            }
                            return node;
                        }
                        return null;
                    }
                    if (node.isNodeType("exo:symlink")) {
                        if (this.checkTargetMatch(node, this.keyword)) {
                            return node;
                        }
                        break block12;
                    }
                    if (node.isNodeType("nt:resource")) {
                        return node.getParent();
                    }
                    if (node.isNodeType("exo:comments")) {
                        return node.getParent().getParent();
                    }
                    return node;
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block12;
                    LOG.warn((Object)e.getMessage());
                }
            }
            return null;
        }

        protected boolean checkTargetMatch(Node symlinkNode, String keyword) {
            String queryStatement = CHECK_LINK_MATCH_QUERY1;
            Node target = null;
            if (keyword == null || keyword.length() == 0) {
                return true;
            }
            if (this.linkManager == null) {
                this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            }
            try {
                if (!this.linkManager.isLink((Item)symlinkNode)) {
                    return true;
                }
                target = this.linkManager.getTarget(symlinkNode);
                if (target == null) {
                    return false;
                }
                Session targetSession = target.getSession();
                queryStatement = StringUtils.replace((String)queryStatement, (String)"$0", (String)target.getPath());
                queryStatement = StringUtils.replace((String)queryStatement, (String)"$1", (String)keyword.replaceAll("'", "''"));
                queryStatement = StringUtils.replace((String)queryStatement, (String)"$2", (String)keyword.replaceAll("'", "''").toLowerCase());
                QueryManager queryManager = targetSession.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(queryStatement, "sql");
                QueryResult queryResult = query.execute();
                if (queryResult.getNodes().getSize() > 0L) {
                    return true;
                }
                if (this.isFodlderDocument(target) || target.hasNode("jcr:content")) {
                    queryStatement = CHECK_LINK_MATCH_QUERY2;
                    queryStatement = StringUtils.replace((String)queryStatement, (String)"$0", (String)target.getPath());
                    queryStatement = StringUtils.replace((String)queryStatement, (String)"$1", (String)keyword.replaceAll("'", "''"));
                    query = queryManager.createQuery(queryStatement = StringUtils.replace((String)queryStatement, (String)"$2", (String)keyword.replaceAll("'", "''").toLowerCase()), "sql");
                    queryResult = query.execute();
                    return queryResult.getNodes().getSize() > 0L;
                }
                return false;
            }
            catch (RepositoryException e) {
                return false;
            }
        }

        private boolean isFodlderDocument(Node node) throws RepositoryException {
            if (!node.isNodeType("nt:unstructured")) {
                return false;
            }
            for (String documentType : this.documentTypes) {
                if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
                return true;
            }
            return false;
        }
    }

    public static class SortDESCActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            SearchComparator comparator = new SearchComparator();
            if (objectId.equals("type")) {
                uiSearchResult.pageList.setSortByField("jcr:primaryType");
                comparator.setSortType("NODE_TYPE");
                iconType = "Up";
                iconScore = "";
            } else if (objectId.equals("score")) {
                uiSearchResult.pageList.setSortByField("jcr:score");
                comparator.setSortType("JCR_SCORE");
                iconScore = "Up";
                iconType = "";
            }
            comparator.setOrderType("DECS");
            uiSearchResult.pageList.setComparator((Comparator)comparator);
            uiSearchResult.pageList.setOrder("DESC");
            uiSearchResult.pageList.sortData();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearchResult.getParent());
        }
    }

    public static class SortASCActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            SearchComparator comparator = new SearchComparator();
            if (objectId.equals("type")) {
                uiSearchResult.pageList.setSortByField("jcr:primaryType");
                comparator.setSortType("NODE_TYPE");
                iconType = "Down";
                iconScore = "";
            } else if (objectId.equals("score")) {
                uiSearchResult.pageList.setSortByField("jcr:score");
                comparator.setSortType("JCR_SCORE");
                iconScore = "Down";
                iconType = "";
            }
            comparator.setOrderType("ASC");
            uiSearchResult.pageList.setComparator((Comparator)comparator);
            uiSearchResult.pageList.setOrder("ASC");
            uiSearchResult.pageList.sortData();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearchResult.getParent());
        }
    }

    public static class OpenFolderActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            Node node;
            String folderPath;
            UIJCRExplorer uiExplorer;
            block4: {
                UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
                uiExplorer = (UIJCRExplorer)uiSearchResult.getAncestorOfType(UIJCRExplorer.class);
                String path = event.getRequestContext().getRequestParameter("objectId");
                folderPath = LinkUtils.getParentPath((String)path);
                node = null;
                try {
                    node = uiExplorer.getNodeByPath(folderPath, uiExplorer.getTargetSession());
                }
                catch (AccessDeniedException ace) {
                    UIApplication uiApp = (UIApplication)uiSearchResult.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.access-denied", null, 1));
                    return;
                }
                catch (PathNotFoundException ace) {
                    UIApplication uiApp = (UIApplication)uiSearchResult.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.access-denied", null, 1));
                    return;
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Cannot access the node at " + folderPath), (Throwable)e);
                }
            }
            uiExplorer.setSelectNode(node.getSession().getWorkspace().getName(), folderPath);
            uiExplorer.refreshExplorer(node, true);
        }
    }

    public static class ViewActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSearchResult.getAncestorOfType(UIJCRExplorer.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiSearchResult.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiSearchResult.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (this.isInTrash(item)) {
                return;
            }
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            }
            uiExplorer.setSelectNode(workspaceName, path);
            ((UIDocumentContainer)uiDocumentWorkspace.getChild(UIDocumentContainer.class)).setRendered(true);
            uiSearchResult.setRendered(false);
            uiExplorer.refreshExplorer((Node)item, true);
        }

        private boolean isInTrash(Item item) throws RepositoryException {
            return item instanceof Node && Utils.isInTrash((Node)((Node)item));
        }
    }

    private static class SearchComparator
    implements Comparator<RowData> {
        public static final String SORT_TYPE = "NODE_TYPE";
        public static final String SORT_SCORE = "JCR_SCORE";
        public static final String ASC = "ASC";
        public static final String DESC = "DECS";
        private String sortType;
        private String orderType;

        private SearchComparator() {
        }

        public void setSortType(String value) {
            this.sortType = value;
        }

        public void setOrderType(String value) {
            this.orderType = value;
        }

        @Override
        public int compare(RowData row1, RowData row2) {
            block6: {
                try {
                    if (SORT_TYPE.equals(this.sortType.trim())) {
                        String s1 = row1.getJcrPrimaryType();
                        String s2 = row2.getJcrPrimaryType();
                        if (DESC.equals(this.orderType.trim())) {
                            return s2.compareTo(s1);
                        }
                        return s1.compareTo(s2);
                    }
                    if (SORT_SCORE.equals(this.sortType.trim())) {
                        Long l1 = row1.getJcrScore();
                        Long l2 = row2.getJcrScore();
                        if (DESC.equals(this.orderType.trim())) {
                            return l2.compareTo(l1);
                        }
                        return l1.compareTo(l2);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"Cannot compare rows", (Throwable)e);
                }
            }
            return 0;
        }
    }
}

