/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.app;

import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class ThreadLocalSessionProviderService
implements SessionProviderService {
    private static final ThreadLocal<SessionProvider> sessionProviderKeeper = new ThreadLocal();
    private static final ThreadLocal<SessionProvider> systemSessionProviderKeeper = new ThreadLocal();

    public SessionProvider getSessionProvider(Object key) {
        return sessionProviderKeeper.get();
    }

    public SessionProvider getSystemSessionProvider(Object key) {
        if (systemSessionProviderKeeper.get() != null) {
            return systemSessionProviderKeeper.get();
        }
        SessionProvider ssp = SessionProvider.createSystemProvider();
        systemSessionProviderKeeper.set(ssp);
        return ssp;
    }

    public void setSessionProvider(Object key, SessionProvider sessionProvider) {
        sessionProviderKeeper.set(sessionProvider);
    }

    public void removeSessionProvider(Object key) {
        if (sessionProviderKeeper.get() != null) {
            sessionProviderKeeper.get().close();
            sessionProviderKeeper.set(null);
        }
        if (systemSessionProviderKeeper.get() != null) {
            systemSessionProviderKeeper.get().close();
            systemSessionProviderKeeper.set(null);
        }
    }
}

