/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeExoLoginHistoryHome
extends UpgradeProductPlugin {
    private static final String HOME = "exo:LoginHistoryHome";
    private static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    private static final String EXO_OWNABLE = "exo:owneable";
    private Log LOG = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private RepositoryService repoService_;

    public UpgradeExoLoginHistoryHome(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)("Starting " + ((Object)((Object)this)).getClass().getName() + " ............"));
        }
        try (SessionProvider sProvider = null;){
            sProvider = SessionProvider.createSystemProvider();
            Session session = sProvider.getSession(this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repoService_.getCurrentRepository());
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(HOME)) {
                Node home = rootNode.getNode(HOME);
                if (home.canAddMixin(EXO_PRIVILEGEABLE)) {
                    home.addMixin(EXO_PRIVILEGEABLE);
                    HashMap<String, String[]> permissions = new HashMap<String, String[]>();
                    permissions.put("*:/platform/administrators", PermissionType.ALL);
                    permissions.put("*:/platform/users", new String[]{"read"});
                    ((ExtendedNode)home).setPermissions(permissions);
                    rootNode.save();
                }
                if (home.canAddMixin(EXO_OWNABLE)) {
                    home.addMixin(EXO_OWNABLE);
                    rootNode.save();
                }
            }
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"Upgrade node /exo:LoginHistoryHome succeeded");
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

