/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.common.service.utils.TraceElement;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;

@Path(value="{portalName}/social/updater")
public class SocialUpdaterRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SocialUpdaterRest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="model")
    public Response updaterModelOverrided(@Context UriInfo uriInfo) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        UserACL acl = (UserACL)CommonsUtils.getService(UserACL.class);
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!acl.getSuperUser().equals(currentUser)) {
            LOG.warn((Object)"You don't have permission to update the model.");
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        TraceElement trace = TraceElement.getInstance((String)"updater social model");
        trace.start();
        ChromatticManager manager = (ChromatticManager)CommonsUtils.getService(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        Session session = null;
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            SessionProviderService sessionProviderService = (SessionProviderService)CommonsUtils.getService(SessionProviderService.class);
            SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
            session = sProvider.getSession(lifeCycle.getWorkspaceName(), repository);
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.registerNodeTypes(this.getModelIS(), 4, "text/xml");
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
            trace.end();
            LOG.info((Object)trace.toString());
        }
        return Util.getResponse("social model updater sucessfully", uriInfo, MediaType.TEXT_PLAIN_TYPE, Response.Status.OK);
    }

    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/chromattic-nodetypes.xml");
    }
}

