/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JmxRemoteLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JmxRemoteLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.mbeans");
    protected String rmiBindAddress = null;
    protected int rmiRegistryPortPlatform = -1;
    protected int rmiServerPortPlatform = -1;
    protected boolean rmiSSL = true;
    protected String[] ciphers = null;
    protected String[] protocols = null;
    protected boolean clientAuth = true;
    protected boolean authenticate = true;
    protected String passwordFile = null;
    protected String loginModuleName = null;
    protected String accessFile = null;
    protected boolean useLocalPorts = false;
    protected JMXConnectorServer csPlatform = null;

    public String getRmiBindAddress() {
        return this.rmiBindAddress;
    }

    public void setRmiBindAddress(String theRmiBindAddress) {
        this.rmiBindAddress = theRmiBindAddress;
    }

    public int getRmiServerPortPlatform() {
        return this.rmiServerPortPlatform;
    }

    public void setRmiServerPortPlatform(int theRmiServerPortPlatform) {
        this.rmiServerPortPlatform = theRmiServerPortPlatform;
    }

    public int getRmiRegistryPortPlatform() {
        return this.rmiRegistryPortPlatform;
    }

    public void setRmiRegistryPortPlatform(int theRmiRegistryPortPlatform) {
        this.rmiRegistryPortPlatform = theRmiRegistryPortPlatform;
    }

    public boolean getUseLocalPorts() {
        return this.useLocalPorts;
    }

    public void setUseLocalPorts(boolean useLocalPorts) {
        this.useLocalPorts = useLocalPorts;
    }

    private void init() {
        String ciphersValue;
        String rmiSSLValue = System.getProperty("com.sun.management.jmxremote.ssl", "true");
        this.rmiSSL = Boolean.parseBoolean(rmiSSLValue);
        String protocolsValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        if (protocolsValue != null) {
            this.protocols = protocolsValue.split(",");
        }
        if ((ciphersValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites")) != null) {
            this.ciphers = ciphersValue.split(",");
        }
        String clientAuthValue = System.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "true");
        this.clientAuth = Boolean.parseBoolean(clientAuthValue);
        String authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate", "true");
        this.authenticate = Boolean.parseBoolean(authenticateValue);
        this.passwordFile = System.getProperty("com.sun.management.jmxremote.password.file", "jmxremote.password");
        this.accessFile = System.getProperty("com.sun.management.jmxremote.access.file", "jmxremote.access");
        this.loginModuleName = System.getProperty("com.sun.management.jmxremote.login.config");
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start" == event.getType()) {
            this.init();
            System.setProperty("java.rmi.server.randomIDs", "true");
            HashMap<String, Object> env = new HashMap<String, Object>();
            RMIClientSocketFactory csf = null;
            RMIServerSocketFactory ssf = null;
            if (this.rmiSSL) {
                if (this.rmiBindAddress != null) {
                    throw new IllegalStateException(sm.getString("jmxRemoteLifecycleListener.sslRmiBindAddress"));
                }
                csf = new SslRMIClientSocketFactory();
                ssf = new SslRMIServerSocketFactory(this.ciphers, this.protocols, this.clientAuth);
            }
            if (this.rmiBindAddress != null) {
                try {
                    ssf = new RmiServerBindSocketFactory(InetAddress.getByName(this.rmiBindAddress));
                }
                catch (UnknownHostException e) {
                    log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{this.rmiBindAddress}), (Throwable)e);
                }
            }
            if (this.useLocalPorts) {
                csf = new RmiClientLocalhostSocketFactory(csf);
            }
            if (csf != null) {
                env.put("jmx.remote.rmi.client.socket.factory", csf);
                env.put("com.sun.jndi.rmi.factory.socket", csf);
            }
            if (ssf != null) {
                env.put("jmx.remote.rmi.server.socket.factory", ssf);
            }
            if (this.authenticate) {
                env.put("jmx.remote.x.password.file", this.passwordFile);
                env.put("jmx.remote.x.access.file", this.accessFile);
                env.put("jmx.remote.x.login.config", this.loginModuleName);
            }
            this.csPlatform = this.createServer("Platform", this.rmiBindAddress, this.rmiRegistryPortPlatform, this.rmiServerPortPlatform, env, csf, ssf, ManagementFactory.getPlatformMBeanServer());
        } else if ("stop" == event.getType()) {
            this.destroyServer("Platform", this.csPlatform);
        }
    }

    private JMXConnectorServer createServer(String serverName, String bindAddress, int theRmiRegistryPort, int theRmiServerPort, HashMap<String, Object> theEnv, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, MBeanServer theMBeanServer) {
        JMXServiceURL serviceUrl;
        try {
            LocateRegistry.createRegistry(theRmiRegistryPort, csf, ssf);
        }
        catch (RemoteException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createRegistryFailed", new Object[]{serverName, Integer.toString(theRmiRegistryPort)}), (Throwable)e);
            return null;
        }
        if (bindAddress == null) {
            bindAddress = "localhost";
        }
        StringBuilder url = new StringBuilder();
        url.append("service:jmx:rmi://");
        url.append(bindAddress);
        url.append(":");
        url.append(theRmiServerPort);
        url.append("/jndi/rmi://");
        url.append(bindAddress);
        url.append(":");
        url.append(theRmiRegistryPort);
        url.append("/jmxrmi");
        try {
            serviceUrl = new JMXServiceURL(url.toString());
        }
        catch (MalformedURLException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidURL", new Object[]{serverName, url.toString()}), (Throwable)e);
            return null;
        }
        JMXConnectorServer cs = null;
        try {
            cs = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, theEnv, theMBeanServer);
            cs.start();
            log.info((Object)sm.getString("jmxRemoteLifecycleListener.start", new Object[]{Integer.toString(theRmiRegistryPort), Integer.toString(theRmiServerPort), serverName}));
        }
        catch (IOException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createServerFailed", new Object[]{serverName}), (Throwable)e);
        }
        return cs;
    }

    private void destroyServer(String serverName, JMXConnectorServer theConnectorServer) {
        if (theConnectorServer != null) {
            try {
                theConnectorServer.stop();
            }
            catch (IOException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.destroyServerFailed", new Object[]{serverName}), (Throwable)e);
            }
        }
    }

    public static class RmiServerBindSocketFactory
    implements RMIServerSocketFactory {
        private final InetAddress bindAddress;

        public RmiServerBindSocketFactory(InetAddress address) {
            this.bindAddress = address;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 0, this.bindAddress);
        }
    }

    public static class RmiClientLocalhostSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FORCED_HOST = "localhost";
        private RMIClientSocketFactory factory = null;

        public RmiClientLocalhostSocketFactory(RMIClientSocketFactory theFactory) {
            this.factory = theFactory;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            if (this.factory == null) {
                return new Socket(FORCED_HOST, port);
            }
            return this.factory.createSocket(FORCED_HOST, port);
        }
    }
}

