/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathAddressIterator;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.core.api.PathElement;

public abstract class AbstractManagedResource
implements ManagedResource,
ManagedResource.Registration {
    protected final PathElement pathElement;
    protected final AbstractManagedResource parent;

    protected AbstractManagedResource(PathElement pathElement, AbstractManagedResource parent) {
        this.pathElement = pathElement;
        this.parent = parent;
    }

    public final ManagedDescription getResourceDescription(PathAddress address) {
        return this.getResourceDescription(address.iterator());
    }

    public final OperationHandler getOperationHandler(PathAddress address, String operationName) {
        OperationEntry entry = this.getOperationEntry(address.iterator(), operationName);
        return entry == null ? null : entry.getOperationHandler();
    }

    public final ManagedDescription getOperationDescription(PathAddress address, String operationName) {
        OperationEntry entry = this.getOperationEntry(address.iterator(), operationName);
        return entry == null ? null : entry.getDescription();
    }

    public Map<String, ManagedDescription> getOperationDescriptions(PathAddress address) {
        HashMap<String, OperationEntry> entries = new HashMap<String, OperationEntry>();
        this.getOperationEntries(address.iterator(), entries);
        HashMap<String, ManagedDescription> map = new HashMap<String, ManagedDescription>(entries.size());
        for (Map.Entry entry : entries.entrySet()) {
            map.put((String)entry.getKey(), ((OperationEntry)entry.getValue()).description);
        }
        return map;
    }

    public final ManagedResource getSubResource(PathAddress address) {
        return this.getSubResource(address.iterator());
    }

    public final Set<String> getSubResourceNames(PathAddress address) {
        return this.getChildNames(address.iterator());
    }

    protected abstract ManagedDescription getResourceDescription(PathAddressIterator var1);

    protected abstract OperationEntry getOperationEntry(PathAddressIterator var1, String var2);

    protected abstract void getOperationEntries(PathAddressIterator var1, Map<String, OperationEntry> var2);

    protected abstract AbstractManagedResource getSubResource(PathAddressIterator var1);

    protected abstract Set<String> getChildNames(PathAddressIterator var1);

    protected String getPath() {
        if (this.parent == null) {
            return this.pathElement == null ? "" : this.pathElement.getValue();
        }
        return this.parent.getPath() + "/" + this.pathElement.getValue();
    }

    protected static final class OperationEntry {
        private final OperationHandler operationHandler;
        private final ManagedDescription description;
        private final boolean inherited;

        protected OperationEntry(OperationHandler operationHandler, ManagedDescription description, boolean inherited) {
            this.operationHandler = operationHandler;
            this.description = description;
            this.inherited = inherited;
        }

        protected OperationHandler getOperationHandler() {
            return this.operationHandler;
        }

        protected ManagedDescription getDescription() {
            return this.description;
        }

        protected boolean isInherited() {
            return this.inherited;
        }
    }
}

