/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.PlatformUpgradeUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeGroupSiteLayoutPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeGroupSiteLayoutPlugin.class);
    private static final String GROUP_SITE_TEMPLATE_NAME = "group.site.template.name";
    private static final String GROUP_SITE_TEMPLATE_LOACTION = "group.site.template.location";
    private DataStorage dataStorage_;
    protected String groupSiteTemplateName;
    protected String groupSiteTemplateLocation;

    public UpgradeGroupSiteLayoutPlugin(DataStorage dataStorage, InitParams initParams) {
        super(initParams);
        this.dataStorage_ = dataStorage;
        this.groupSiteTemplateName = initParams.getValueParam(GROUP_SITE_TEMPLATE_NAME).getValue();
        this.groupSiteTemplateLocation = initParams.getValueParam(GROUP_SITE_TEMPLATE_LOACTION).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Query query = new Query(this.groupSiteTemplateName, null, PortalConfig.class);
            LazyPageList usersPortalConfig = this.dataStorage_.find(query);
            if (usersPortalConfig == null) {
                LOG.info((Object)"No Group Site was found, no upgrade operation will be done.");
                return;
            }
            PortalConfig tempPortalConfig = PlatformUpgradeUtils.getPortalConfigFromTemplate(PortalConfig.GROUP_TYPE, this.groupSiteTemplateName, this.groupSiteTemplateLocation);
            for (PortalConfig userPortalConfig : usersPortalConfig.getAll()) {
                LOG.info((Object)("Proceed group site layout migration: " + userPortalConfig.getName()));
                PortalConfig newPortalConfig = new PortalConfig(PortalConfig.GROUP_TYPE, userPortalConfig.getName(), userPortalConfig.getStorageId());
                newPortalConfig.setStorageName(userPortalConfig.getStorageName());
                newPortalConfig.setName(userPortalConfig.getName());
                newPortalConfig.setAccessPermissions(userPortalConfig.getAccessPermissions());
                newPortalConfig.setDescription(userPortalConfig.getDescription());
                newPortalConfig.setEditPermission(userPortalConfig.getEditPermission());
                newPortalConfig.setLabel(userPortalConfig.getLabel());
                newPortalConfig.setModifiable(userPortalConfig.isModifiable());
                newPortalConfig.setPortalLayout(tempPortalConfig.getPortalLayout());
                newPortalConfig.setPortalRedirects(userPortalConfig.getPortalRedirects());
                newPortalConfig.setType(userPortalConfig.getType());
                this.dataStorage_.save(newPortalConfig);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error during Group Layout migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

