/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class NameReferenceGraph
extends LinkedDirectedGraph<Name, Reference>
implements DefinitionProvider {
    private final Multimap<Node, Name> referenceMap = HashMultimap.create();
    private Map<String, Name> nameMap = Maps.newHashMap();
    final Name UNKNOWN;
    final Name MAIN;
    final Name WINDOW;
    final AbstractCompiler compiler;

    public NameReferenceGraph(AbstractCompiler compiler) {
        super(true, true);
        this.compiler = compiler;
        this.UNKNOWN = new Name("{UNKNOWN}", true);
        this.UNKNOWN.isAliased = true;
        this.UNKNOWN.type = compiler.getTypeRegistry().getNativeType(JSTypeNative.NO_TYPE);
        this.createNode(this.UNKNOWN);
        this.MAIN = new Name("{Global Main}", true);
        this.createNode(this.MAIN);
        this.WINDOW = new Name("window", true);
        this.createNode(this.WINDOW);
    }

    public Name defineNameIfNotExists(String name, boolean isExtern) {
        Name symbol = null;
        if (this.nameMap.containsKey(name)) {
            symbol = this.nameMap.get(name);
        } else {
            symbol = new Name(name, isExtern);
            this.nameMap.put(name, symbol);
            this.createNode(symbol);
        }
        return symbol;
    }

    public List<Name> getReferencesAt(Node site) {
        Preconditions.checkArgument((site.isGetProp() || site.isName() ? 1 : 0) != 0);
        ArrayList<Name> result = new ArrayList<Name>();
        for (Name target : this.referenceMap.get((Object)site)) {
            result.add(target);
        }
        return result;
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node useSite) {
        List<Name> nameRefs = this.getReferencesAt(useSite);
        if (nameRefs.isEmpty()) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (Name nameRef : nameRefs) {
            List<DefinitionsRemover.Definition> decls = nameRef.getDeclarations();
            if (decls.isEmpty()) continue;
            result.addAll(decls);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public Name getSymbol(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public GraphNode<Name, Reference> createNode(Name value) {
        this.nameMap.put(value.qName, value);
        return super.createNode(value);
    }

    @Override
    public void connect(Name src, Reference ref, Name dest) {
        super.connect(src, ref, dest);
        this.referenceMap.put((Object)ref.site, (Object)dest);
    }

    static class Reference {
        public final Node site;
        public final Node parent;
        private JSModule module = null;
        private boolean isUnknown = false;

        public Reference(Node site, Node parent) {
            this.site = site;
            this.parent = parent;
        }

        public boolean isUnknown() {
            return this.isUnknown;
        }

        public void setUnknown(boolean isUnknown) {
            this.isUnknown = isUnknown;
        }

        public JSModule getModule() {
            return this.module;
        }

        public void setModule(JSModule module) {
            this.module = module;
        }

        boolean isCall() {
            return this.site.isCall();
        }

        public Node getSite() {
            return this.site;
        }
    }

    class Name {
        private final String qName;
        private JSType type;
        private List<DefinitionsRemover.Definition> declarations = Lists.newLinkedList();
        final boolean isExtern;
        private boolean isExported = false;
        private boolean isAliased = false;
        private boolean exposedToCallOrApply = false;

        public Name(String qName, boolean isExtern) {
            this.qName = qName;
            this.isExtern = isExtern;
            int lastDot = qName.lastIndexOf(46);
            String name = lastDot == -1 ? qName : qName.substring(lastDot + 1);
            this.isExported = NameReferenceGraph.this.compiler.getCodingConvention().isExported(name);
            this.type = NameReferenceGraph.this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        public JSType getType() {
            return this.type;
        }

        public void setType(JSType type) {
            this.type = type;
        }

        public List<DefinitionsRemover.Definition> getDeclarations() {
            return this.declarations;
        }

        public void addAssignmentDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.AssignmentDefinition(node, this.isExtern));
        }

        public void addFunctionDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.NamedFunctionDefinition(node, this.isExtern));
        }

        public boolean isExtern() {
            return this.isExtern;
        }

        public void markExported() {
            this.isExported = true;
        }

        public boolean isExported() {
            return this.isExported;
        }

        public final void remove() {
            for (DefinitionsRemover.Definition declaration : this.getDeclarations()) {
                declaration.remove();
            }
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public void setAliased(boolean isAliased) {
            this.isAliased = isAliased;
        }

        public boolean hasSideEffect() {
            return this.isCallable();
        }

        public String getQualifiedName() {
            return this.qName;
        }

        public String getPropertyName() {
            int lastIndexOfDot = this.qName.lastIndexOf(46);
            if (lastIndexOfDot == -1) {
                return null;
            }
            return this.qName.substring(lastIndexOfDot + 1);
        }

        public boolean isCallable() {
            return this.type.canBeCalled();
        }

        public boolean exposedToCallOrApply() {
            return this.exposedToCallOrApply;
        }

        public void markExposedToCallOrApply() {
            this.exposedToCallOrApply = true;
        }

        public String toString() {
            return this.qName + " : " + this.type;
        }

        public int hashCode() {
            return this.qName.hashCode();
        }

        public boolean canChangeSignature() {
            return !this.isExtern() && this.isCallable() && !this.isAliased() && !this.isExported() && !this.exposedToCallOrApply() && !this.nameUsesArgumentsProperty();
        }

        private boolean nameUsesArgumentsProperty() {
            for (DefinitionsRemover.Definition definition : this.getDeclarations()) {
                if (!NodeUtil.isVarArgsFunction(definition.getRValue())) continue;
                return true;
            }
            return false;
        }
    }
}

