/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;

public class AnonymousSecurityToken
extends AbstractSecurityToken
implements SecurityToken {
    private final String container;
    private final long moduleId;
    private final String appUrl;
    private final Long expiresAt;

    public AnonymousSecurityToken() {
        this("default");
    }

    public AnonymousSecurityToken(String container) {
        this(container, 0L, "", null);
    }

    public AnonymousSecurityToken(String container, long moduleId, String appUrl, Long expiresAt) {
        this.container = container;
        this.moduleId = moduleId;
        this.appUrl = appUrl;
        this.expiresAt = expiresAt;
    }

    public boolean isAnonymous() {
        return true;
    }

    public String getOwnerId() {
        return "-1";
    }

    public String getViewerId() {
        return "-1";
    }

    public String getAppId() {
        return this.appUrl;
    }

    public String getDomain() {
        return "";
    }

    public String getContainer() {
        return this.container;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getUpdatedToken() {
        return "";
    }

    public String getAuthenticationMode() {
        return AuthenticationMode.UNAUTHENTICATED.name();
    }

    public String getTrustedJson() {
        return "";
    }
}

