/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.service;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.UrlImpl;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;
import org.exoplatform.social.opensocial.model.ExoPersonImpl;
import org.exoplatform.social.opensocial.model.Space;
import org.exoplatform.social.opensocial.model.SpaceImpl;
import org.exoplatform.social.opensocial.service.ExoService;

public class ExoPeopleService
extends ExoService
implements PersonService,
AppDataService {
    private Injector injector;
    private static final Log LOG = ExoLogger.getLogger(ExoPeopleService.class);
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };

    @Inject
    public ExoPeopleService(Injector injector) {
        this.injector = injector;
    }

    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, SecurityToken token) throws ProtocolException {
        List result = Lists.newArrayList();
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            for (Identity id : idSet) {
                if (id == null) continue;
                result.add(this.convertToPerson(id, fields, token));
            }
            if (collectionOptions.getSortBy().equals(Person.Field.NAME.toString())) {
                Collections.sort(result, NAME_COMPARATOR);
            }
            if (collectionOptions.getSortOrder().equals((Object)SortOrder.descending)) {
                Collections.reverse(result);
            }
            int totalSize = result.size();
            int fromIndex = collectionOptions.getFirst();
            int toIndex = fromIndex + collectionOptions.getMax();
            fromIndex = fromIndex < 0 ? 0 : fromIndex;
            toIndex = totalSize < toIndex ? totalSize : toIndex;
            toIndex = toIndex < fromIndex ? fromIndex : toIndex;
            result = result.subList(fromIndex, toIndex);
            return ImmediateFuture.newInstance((Object)new RestfulCollection(result, collectionOptions.getFirst(), totalSize));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            Identity identity = this.getIdentity(id.getUserId(token), true, token);
            return ImmediateFuture.newInstance((Object)this.convertToPerson(identity, fields, token));
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
    }

    private Person convertToPerson(Identity identity, Set<String> fields, SecurityToken st) throws Exception {
        ExoPersonImpl p = new ExoPersonImpl();
        Profile pro = identity.getProfile();
        PortalContainer container = this.getPortalContainer(st);
        String host = this.getHost(st);
        for (String field : fields) {
            if (Person.Field.DISPLAY_NAME.toString().equals(field)) {
                p.setDisplayName(pro.getFullName());
                continue;
            }
            if (Person.Field.EMAILS.toString().equals(field)) {
                p.setEmails(this.convertToListFields((List)pro.getProperty("emails")));
                continue;
            }
            if (Person.Field.URLS.toString().equals(field)) {
                p.setUrls(this.convertToURLListFields((List)pro.getProperty("urls")));
                continue;
            }
            if (Person.Field.IMS.toString().equals(field)) {
                p.setIms(this.convertToListFields((List)pro.getProperty("ims")));
                continue;
            }
            if (Person.Field.ID.toString().equals(field)) {
                p.setId(identity.getId());
                continue;
            }
            if (Person.Field.NAME.toString().equals(field)) {
                NameImpl name = new NameImpl();
                name.setFamilyName((String)pro.getProperty("lastName"));
                name.setGivenName((String)pro.getProperty("firstName"));
                name.setFormatted(name.getGivenName() + " " + name.getFamilyName());
                p.setName((Name)name);
                continue;
            }
            if (Person.Field.PROFILE_URL.toString().equals(field)) {
                String portalOwner = this.getPortalOwner(st);
                String portalName = this.getPortalContainer(st).getName();
                p.setProfileUrl(LinkProvider.getAbsoluteProfileUrl((String)identity.getRemoteId(), (String)portalName, (String)portalOwner, (String)host));
                continue;
            }
            if (Person.Field.GENDER.toString().equals(field)) {
                String gender = (String)pro.getProperty("gender");
                if (gender != null && gender.equals("female")) {
                    p.setGender(Person.Gender.female);
                    continue;
                }
                p.setGender(Person.Gender.male);
                continue;
            }
            if (ExoPersonImpl.Field.SPACES.toString().equals(field)) {
                ArrayList<Space> spaces = new ArrayList<Space>();
                SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
                try {
                    ListAccess memberSpaceListAccess = spaceService.getMemberSpaces(identity.getRemoteId());
                    org.exoplatform.social.core.space.model.Space[] spaceArray = (org.exoplatform.social.core.space.model.Space[])memberSpaceListAccess.load(0, 100);
                    SpaceImpl space = new SpaceImpl();
                    for (org.exoplatform.social.core.space.model.Space spaceObj : spaceArray) {
                        space.setId(spaceObj.getId());
                        space.setDisplayName(spaceObj.getDisplayName());
                        spaces.add(space);
                    }
                    p.setSpaces(spaces);
                }
                catch (SpaceException e) {
                    LOG.warn((Object)"Failed to convert spaces!");
                }
                continue;
            }
            if (Person.Field.THUMBNAIL_URL.toString().equals(field)) {
                String avatarUrl = pro.getAvatarUrl();
                if (avatarUrl != null) {
                    p.setThumbnailUrl(host + avatarUrl);
                    continue;
                }
                p.setThumbnailUrl(host + "/eXoSkin/skin/images/system/UserAvtDefault.png");
                continue;
            }
            if (ExoPersonImpl.Field.PORTAL_CONTAINER.toString().equals(field)) {
                p.setPortalName(container.getName());
                continue;
            }
            if (ExoPersonImpl.Field.REST_CONTEXT.toString().equals(field)) {
                p.setRestContextName(container.getRestContextName());
                continue;
            }
            if (ExoPersonImpl.Field.HOST.toString().equals(field)) {
                p.setHostName(this.getHost(st));
                continue;
            }
            if (!ExoPersonImpl.Field.PEOPLE_URI.toString().equals(field)) continue;
            p.setPeopleUri(this.getURIForPeople(container, identity.getRemoteId()));
        }
        return p;
    }

    private List<ListField> convertToListFields(List<Map> fields) {
        ArrayList<ListField> l = new ArrayList<ListField>();
        if (fields == null) {
            return null;
        }
        for (Map field : fields) {
            l.add((ListField)new ListFieldImpl((String)field.get("key"), (String)field.get("value")));
        }
        return l;
    }

    private List<Url> convertToURLListFields(List<Map> fields) {
        ArrayList<Url> l = new ArrayList<Url>();
        if (fields == null) {
            return null;
        }
        for (Map field : fields) {
            l.add((Url)new UrlImpl((String)field.get("value"), (String)field.get("key"), (String)field.get("key")));
        }
        return l;
    }

    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            HashMap<String, Map<String, String>> idToData = new HashMap<String, Map<String, String>>();
            Iterator<Identity> it = idSet.iterator();
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            while (it.hasNext()) {
                Identity id = it.next();
                idToData.put(id.getId(), this.getPreferences(id.getRemoteId(), gadgetId, instanceId, fields));
            }
            return ImmediateFuture.newInstance((Object)new DataCollection(idToData));
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
    }

    private String clean(String url) {
        url = URLEncoder.encode(url);
        url = url.replaceAll(":", "");
        return url;
    }

    private Map<String, String> getPreferences(String userID, String gadgetId, String instanceID, Set<String> fields) throws Exception {
        Map<String, String> values = null;
        return values;
    }

    private void savePreferences(String userID, String gadgetId, String instanceID, Map<String, String> values) throws Exception {
    }

    private void deletePreferences(String userID, String gadgetId, String instanceID, Set<String> keys) throws Exception {
    }

    public Future<Void> deletePersonData(UserId user, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            String userId = user.getUserId(token);
            String portalName = PortalContainer.getCurrentPortalContainerName();
            if (token instanceof ExoBlobCrypterSecurityToken) {
                portalName = ((ExoBlobCrypterSecurityToken)token).getPortalContainer();
            }
            Identity id = this.getIdentity(userId, true, token);
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            this.deletePreferences(id.getRemoteId(), gadgetId, instanceId, fields);
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    public Future<Void> updatePersonData(UserId user, GroupId groupId, String appId, Set<String> fields, Map<String, String> values, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            String userId = user.getUserId(token);
            Identity id = this.getIdentity(userId, true, token);
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            this.savePreferences(id.getRemoteId(), gadgetId, instanceId, values);
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURIForPeople(PortalContainer portalContainer, String remoteId) throws Exception {
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)portalContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        StringBuffer stringBuffer = new StringBuffer();
        RequestLifeCycle.begin((ExoContainer)portalContainer);
        try {
            UserNode iteratorNode;
            UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
            UserPortal userPortal = userPortalCfg.getUserPortal();
            SiteKey siteKey = SiteKey.portal((String)userPortalConfigSer.getDefaultPortal());
            UserNavigation userNav = userPortal.getNavigation(siteKey);
            UserNode rootNode = userPortal.getNode(userNav, Scope.ALL, null, null);
            if (iteratorNode != null) {
                UserNode peopleNode;
                for (iteratorNode = peopleNode = rootNode.getChild("people"); iteratorNode != null && iteratorNode.getParent() != null; iteratorNode = iteratorNode.getParent()) {
                    stringBuffer.insert(0, iteratorNode.getName());
                    stringBuffer.insert(0, "/");
                }
                stringBuffer.insert(0, userPortalConfigSer.getDefaultPortal());
                stringBuffer.insert(0, "/");
                stringBuffer.insert(0, portalContainer.getName());
                stringBuffer.insert(0, "/");
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not get the people page node.");
        }
        finally {
            RequestLifeCycle.end();
        }
        return stringBuffer.toString();
    }
}

