/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.handler;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.jcr.Node;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.ecm.utils.MessageDigester;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class SiteJavascriptHandler
extends WebRequestHandler {
    private ExoCache<String, Object> jsCache_;
    private String siteName_;
    private LivePortalManagerService livePortalManagerService_;
    private static final String CACHE_REGION = "ecms.site.javascript.cache";

    public String getHandlerName() {
        return "javascript";
    }

    public synchronized boolean execute(ControllerContext context) throws Exception {
        if (this.jsCache_ == null) {
            this.jsCache_ = WCMCoreUtils.getService(CacheService.class).getCacheInstance(CACHE_REGION);
        }
        this.siteName_ = context.getParameter(QualifiedName.create((String)"gtn", (String)"sitename"));
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        this.livePortalManagerService_ = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node portalNode = null;
        portalNode = "shared".equals(this.siteName_) ? this.livePortalManagerService_.getLiveSharedPortal(sessionProvider) : this.livePortalManagerService_.getLivePortal(sessionProvider, this.siteName_);
        String jsData = (String)this.jsCache_.get((Serializable)((Object)MessageDigester.getHash(this.siteName_)));
        if (jsData == null || jsData.trim().length() == 0) {
            jsData = WCMCoreUtils.getSiteGlobalActiveJs(portalNode);
            this.jsCache_.put((Serializable)((Object)MessageDigester.getHash(this.siteName_)), (Object)jsData);
        }
        HttpServletResponse res = context.getResponse();
        res.setContentType("text/javascript");
        PrintWriter out = res.getWriter();
        out.println(jsData);
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

