/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.rest.HttpManagedRequest;

class HttpManagedRequestBuilder {
    private String path;
    private String operationName;
    private ContentType contentType;
    private InputStream inputStream;
    private MultivaluedMap<String, String> parameters;
    private String httpMethod;

    public static HttpManagedRequestBuilder get() {
        return new HttpManagedRequestBuilder("read-resource", "GET");
    }

    public static HttpManagedRequestBuilder post(InputStream inputStream) {
        return new HttpManagedRequestBuilder("add-resource", inputStream, "POST");
    }

    public static HttpManagedRequestBuilder put(InputStream inputStream) {
        return new HttpManagedRequestBuilder("update-resource", inputStream, "PUT");
    }

    public static HttpManagedRequestBuilder delete() {
        return new HttpManagedRequestBuilder("remove-resource", "DELETE");
    }

    private HttpManagedRequestBuilder(String operationName, String httpMethod) {
        this(operationName, null, httpMethod);
    }

    private HttpManagedRequestBuilder(String operationName, InputStream inputStream, String httpMethod) {
        this.operationName = operationName;
        this.inputStream = inputStream;
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public HttpManagedRequestBuilder path(String path) {
        if (path == null) {
            path = "";
        }
        this.path = path;
        return this;
    }

    public HttpManagedRequestBuilder parameters(MultivaluedMap<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public HttpManagedRequestBuilder contentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public HttpManagedRequestBuilder operationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public HttpManagedRequest build() {
        String op = (String)this.parameters.getFirst((Object)"op");
        if (op != null) {
            this.operationName = op;
            if (this.operationName.equals("read-config-as-xml")) {
                this.contentType = ContentType.XML;
            } else if (this.operationName.equals("export-resource")) {
                this.contentType = ContentType.ZIP;
            }
        }
        if (this.contentType == null) {
            String format = (String)this.parameters.getFirst((Object)"format");
            this.contentType = ContentType.forName((String)format);
        }
        if (this.path.endsWith(".xml")) {
            this.path = this.path.substring(0, this.path.lastIndexOf(".xml"));
            this.operationName = "read-config-as-xml";
            this.contentType = ContentType.XML;
        } else if (this.path.endsWith(".zip")) {
            this.path = this.path.substring(0, this.path.lastIndexOf(".zip"));
            this.operationName = "export-resource";
            this.contentType = ContentType.ZIP;
        }
        PathAddress address = PathAddress.pathAddress((String)this.path);
        if (this.contentType == null) {
            this.contentType = ContentType.JSON;
        }
        ManagedRequest request = ManagedRequest.Factory.create((String)this.operationName, (PathAddress)address, this.parameters, (InputStream)this.inputStream, (ContentType)this.contentType);
        return new HttpManagedRequestDelegate(request, this.httpMethod);
    }

    private static class HttpManagedRequestDelegate
    implements HttpManagedRequest {
        private ManagedRequest delegate;
        private String httpMethod;

        private HttpManagedRequestDelegate(ManagedRequest delegate, String httpMethod) {
            this.delegate = delegate;
            this.httpMethod = httpMethod;
        }

        public String getOperationName() {
            return this.delegate.getOperationName();
        }

        public PathAddress getAddress() {
            return this.delegate.getAddress();
        }

        public Map<String, List<String>> getAttributes() {
            return this.delegate.getAttributes();
        }

        public InputStream getDataStream() {
            return this.delegate.getDataStream();
        }

        public ContentType getContentType() {
            return this.delegate.getContentType();
        }

        @Override
        public String getHttpMethod() {
            return this.httpMethod;
        }
    }
}

