/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class IsNotIgnoreVersionNodeFilter
implements UIExtensionFilter {
    public boolean accept(Map<String, Object> context) throws Exception {
        String[] arrNodetypes;
        if (context == null) {
            return true;
        }
        boolean ignore_version = true;
        Node currentNode = (Node)context.get(Node.class.getName());
        Node parrentNode = currentNode.getParent();
        ExtendedNodeTypeManager ntmanager = WCMCoreUtils.getRepository().getNodeTypeManager();
        String nodetypes = System.getProperty("wcm.nodetypes.ignoreversion");
        if (nodetypes == null || nodetypes.length() == 0) {
            nodetypes = "exo:webContent";
        }
        for (String nodetype : arrNodetypes = nodetypes.split(",")) {
            try {
                ntmanager.getNodeType(nodetype);
            }
            catch (NoSuchNodeTypeException e) {
                ignore_version = true;
            }
            while (!((NodeImpl)parrentNode).isRoot()) {
                if (parrentNode.isNodeType(nodetype)) {
                    return false;
                }
                parrentNode = parrentNode.getParent();
            }
        }
        return ignore_version;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

