/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends ASN1Object {
    String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (l < 0x80000000000000L) {
                l = l * 128L + (long)(n & 0x7F);
                if ((n & 0x80) != 0) continue;
                if (bl) {
                    switch ((int)l / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l -= 80L;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(l);
                l = 0L;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.shiftLeft(7);
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) != 0) continue;
            stringBuffer.append('.');
            stringBuffer.append(bigInteger);
            bigInteger = null;
            l = 0L;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        if (!DERObjectIdentifier.isValidIdentifier(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream outputStream, long l) throws IOException {
        if (l >= 128L) {
            if (l >= 16384L) {
                if (l >= 0x200000L) {
                    if (l >= 0x10000000L) {
                        if (l >= 0x800000000L) {
                            if (l >= 0x40000000000L) {
                                if (l >= 0x2000000000000L) {
                                    if (l >= 0x100000000000000L) {
                                        outputStream.write((int)(l >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l >> 49) | 0x80);
                                }
                                outputStream.write((int)(l >> 42) | 0x80);
                            }
                            outputStream.write((int)(l >> 35) | 0x80);
                        }
                        outputStream.write((int)(l >> 28) | 0x80);
                    }
                    outputStream.write((int)(l >> 21) | 0x80);
                }
                outputStream.write((int)(l >> 14) | 0x80);
            }
            outputStream.write((int)(l >> 7) | 0x80);
        }
        outputStream.write((int)l & 0x7F);
    }

    private void writeField(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        int n = (bigInteger.bitLength() + 6) / 7;
        if (n == 0) {
            outputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n2 = n - 1;
            byArray[n2] = (byte)(byArray[n2] & 0x7F);
            outputStream.write(byArray);
        }
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        Object object;
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.writeField((OutputStream)byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            object = oIDTokenizer.nextToken();
            if (((String)object).length() < 18) {
                this.writeField((OutputStream)byteArrayOutputStream, Long.parseLong((String)object));
                continue;
            }
            this.writeField((OutputStream)byteArrayOutputStream, new BigInteger((String)object));
        }
        dEROutputStream2.close();
        object = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, (byte[])object);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)dERObject).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c = string.charAt(0);
        if (c < '0' || c > '2') {
            return false;
        }
        boolean bl = false;
        for (int i = string.length() - 1; i >= 2; --i) {
            char c2 = string.charAt(i);
            if ('0' <= c2 && c2 <= '9') {
                bl = true;
                continue;
            }
            if (c2 == '.') {
                if (!bl) {
                    return false;
                }
                bl = false;
                continue;
            }
            return false;
        }
        return bl;
    }
}

