/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.social.webui.space.UISpaceInfo;
import org.exoplatform.social.webui.space.UISpaceMember;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpacePermission;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.event.Event;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceSetting.gtmpl"), @ComponentConfig(type=UITabPane.class, id="UISpaceSettingTabPane", template="war:/groovy/social/webui/space/UISpaceSettingPane.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})})
public class UISpaceSetting
extends UITabPane {
    private Space space;

    public UISpaceSetting() throws Exception {
        UITabPane uiTabPane = (UITabPane)this.addChild(UITabPane.class, null, null);
        uiTabPane.setComponentConfig(UITabPane.class, "UISpaceSettingTabPane");
        uiTabPane.addChild(UISpaceInfo.class, null, null);
        uiTabPane.addChild(UISpacePermission.class, null, null);
        uiTabPane.addChild(UISpaceMember.class, null, null);
        uiTabPane.addChild(UISpaceApplication.class, null, null);
        uiTabPane.addChild(UISpaceNavigationManagement.class, null, null);
        uiTabPane.setSelectedTab(1);
        String spaceUrl = SpaceUtils.getSpaceUrl();
        Space space = ((SpaceService)this.getApplicationComponent(SpaceService.class)).getSpaceByUrl(spaceUrl);
        if (space != null) {
            this.setValues(space);
        }
    }

    public void initTabByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route != null) {
            String app = (String)route.localArgs.get("appName");
            String path = (String)route.localArgs.get("path");
            if ("settings".equals(app) && "members".equals(path)) {
                ((UITabPane)this.getChild(UITabPane.class)).setSelectedTab(3);
            }
        }
    }

    public void setValues(Space space) throws Exception {
        UISpaceInfo uiSpaceInfo = (UISpaceInfo)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceInfo.class);
        uiSpaceInfo.setValue(space);
        UISpaceMember uiSpaceMember = (UISpaceMember)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceMember.class);
        uiSpaceMember.setValue(space.getId());
        uiSpaceMember.setSpaceURL(space.getUrl());
        UISpaceApplication uiSpaceApplication = (UISpaceApplication)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceApplication.class);
        uiSpaceApplication.setValue(space);
        UISpacePermission uiSpacePermission = (UISpacePermission)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpacePermission.class);
        uiSpacePermission.setValue(space);
        this.space = space;
        PortalRequestContext pContext = Util.getPortalRequestContext();
        UISpaceNavigationManagement uiSpaceNavigation = (UISpaceNavigationManagement)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceNavigationManagement.class);
        uiSpaceNavigation.reloadTreeData();
        UISpaceSetting uiSpaceSetting = (UISpaceSetting)((UITabPane)this.getChild(UITabPane.class)).getParent();
        uiSpaceNavigation.setSpace(uiSpaceSetting.getSpace());
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceNavigation);
    }

    protected Space getSpace() {
        return this.space;
    }

    public String getSpaceName() {
        return this.space.getDisplayName();
    }

    public boolean isLeader() throws Exception {
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        Space currentSpace = spaceSrc.getSpaceById(this.space.getId());
        return spaceSrc.hasEditPermission(currentSpace, userId);
    }

    protected void redirectToHome(WebuiRequestContext ctx) {
        JavascriptManager jsManager = ctx.getJavascriptManager();
        jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(this.space) + "' } catch(e) {" + "window.location.href('" + Utils.getSpaceHomeURL(this.space) + "') }"));
    }

    public static class SelectTabActionListener
    extends UITabPane.SelectTabActionListener {
        public void execute(Event<UITabPane> event) throws Exception {
            UISpaceApplication uiApplication;
            UITabPane uiTabPane = (UITabPane)event.getSource();
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            if (renderTab.equals(UISpaceNavigationManagement.class.getSimpleName())) {
                UISpaceNavigationManagement uiSpaceNavigation = (UISpaceNavigationManagement)uiTabPane.getChild(UISpaceNavigationManagement.class);
                UISpaceSetting uiSpaceSetting = (UISpaceSetting)uiTabPane.getParent();
                uiSpaceNavigation.setSpace(uiSpaceSetting.getSpace());
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceNavigation);
            }
            if (!renderTab.equals(UISpaceApplication.class.getSimpleName()) && (uiApplication = (UISpaceApplication)uiTabPane.getChild(UISpaceApplication.class)) != null) {
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiApplication.getChild(UIPopupContainer.class);
                uiPopupContainer.deActivate();
            }
            uiTabPane.setSelectedTab(renderTab);
            context.addUIComponentToUpdateByAjax((UIComponent)uiTabPane);
        }
    }
}

