/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.security.PrivilegedAction;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="EXO_USER_PROFILE")
public class UserProfileData {
    private static transient XStream xstream_;
    @Id
    private String userName;
    @Column(length=65536)
    @Type(type="org.exoplatform.services.database.impl.TextClobType")
    private String profile;

    public UserProfileData() {
    }

    public UserProfileData(String userName) {
        StringBuffer b = new StringBuffer();
        b.append("<user-profile>\n").append("  <userName>").append(userName).append("</userName>\n");
        b.append("</user-profile>\n");
        this.userName = userName;
        this.profile = b.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String s) {
        this.userName = s;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String s) {
        this.profile = s;
    }

    public UserProfile getUserProfile() {
        final XStream xstream = UserProfileData.getXStream();
        UserProfileImpl up = (UserProfileImpl)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<UserProfileImpl>(){

            @Override
            public UserProfileImpl run() {
                return (UserProfileImpl)xstream.fromXML(UserProfileData.this.profile);
            }
        });
        return up;
    }

    public void setUserProfile(UserProfile up) {
        if (up == null) {
            this.profile = "";
            return;
        }
        final UserProfileImpl impl = (UserProfileImpl)up;
        this.userName = up.getUserName();
        final XStream xstream = UserProfileData.getXStream();
        this.profile = (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

            @Override
            public String run() {
                return xstream.toXML((Object)impl);
            }
        });
    }

    private static XStream getXStream() {
        if (xstream_ == null) {
            xstream_ = (XStream)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<XStream>(){

                @Override
                public XStream run() {
                    return new XStream((HierarchicalStreamDriver)new XppDriver());
                }
            });
            xstream_.alias("user-profile", UserProfileImpl.class);
        }
        return xstream_;
    }
}

