/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;

public class HttpClientTransportOverHTTP
extends AbstractHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination);
        Promise promise = (Promise)context.get("http.connection.promise");
        promise.succeeded((Object)connection);
        return connection;
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination) {
        return new HttpConnectionOverHTTP(endPoint, destination);
    }
}

