/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.calendar.service.AbstractBean;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Attachment
extends AbstractBean {
    private static final Log log = ExoLogger.getExoLogger(Attachment.class);
    private String name;
    private String mimeType;
    private long size;
    private byte[] imageBytes;
    private String workspace;
    private String resourceId;

    public Attachment() {
        this.setId("Attachment" + IdGenerator.generate());
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType_) {
        this.mimeType = mimeType_;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size_) {
        this.size = size_;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public String getDataPath() {
        block3: {
            try {
                Node attachmentData;
                if (this.getSesison() != null && (attachmentData = (Node)this.getSesison().getItem(this.getId())) != null) {
                    return attachmentData.getPath();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"The attachment note is not exist", (Throwable)e);
            }
        }
        return null;
    }

    private Session getSesison() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getCurrentRepository().getSystemSession(this.workspace);
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    public InputStream getInputStream() throws Exception {
        Node attachment;
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        try {
            attachment = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        return attachment.getNode("jcr:content").getProperty("jcr:data").getStream();
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

