/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Locale;
import java.util.TimeZone;
import org.exoplatform.calendar.service.AbstractBean;
import org.exoplatform.services.jcr.util.IdGenerator;

public class Calendar
extends AbstractBean {
    public static final int TYPE_PRIVATE = 0;
    public static final int TYPE_SHARED = 1;
    public static final int TYPE_PUBLIC = 2;
    public static final int TYPE_ALL = -1;
    public static final String N_ASPARAGUS = "asparagus";
    public static final String N_MUNSELL_BLUE = "munsell_blue";
    public static final String N_NAVY_BLUE = "navy_blue";
    public static final String N_PURPLE = "purple";
    public static final String N_RED = "red";
    public static final String N_BROWN = "brown";
    public static final String N_LAUREL_GREEN = "laurel_green";
    public static final String N_SKY_BLUE = "sky_blue";
    public static final String N_BLUE_GRAY = "blue_gray";
    public static final String N_LIGHT_PURPLE = "light_purple";
    public static final String N_HOT_PINK = "hot_pink";
    public static final String N_LIGHT_BROWN = "light_brown";
    public static final String N_MOSS_GREEN = "moss_green";
    public static final String N_POWDER_BLUE = "powder_blue";
    public static final String N_LIGHT_BLUE = "light_blue";
    public static final String N_PINK = "pink";
    public static final String N_ORANGE = "orange";
    public static final String N_GRAY = "gray";
    public static final String N_GREEN = "green";
    public static final String N_BABY_BLUE = "baby_blue";
    public static final String N_LIGHT_GRAY = "light_gray";
    public static final String N_BEIGE = "beige";
    public static final String N_YELLOW = "yellow";
    public static final String N_PLUM_PURPLE = "#CEA6AC";
    public static final String[] COLORS = new String[]{"asparagus", "munsell_blue", "navy_blue", "purple", "red", "brown", "laurel_green", "sky_blue", "blue_gray", "light_purple", "hot_pink", "light_brown", "moss_green", "powder_blue", "light_blue", "pink", "orange", "gray", "green", "baby_blue", "light_gray", "beige", "yellow", "#CEA6AC"};
    private String name;
    private String calendarColor = "powder_blue";
    private String description;
    private String timeZone;
    private String locale;
    private String calendarOwner;
    private String[] viewPermission;
    private String[] editPermission;
    private String[] groups;
    private String publicUrl;
    private String privateUrl;
    private String _calendarPath;
    private boolean _isDataInit = false;
    private boolean _isPublic = false;
    private int _calType;
    private boolean remote = false;
    private boolean hasChildren = false;
    public static final String CALENDAR_PREF = "calendar";

    public Calendar() {
        this.setId(CALENDAR_PREF + IdGenerator.generate());
        this.timeZone = TimeZone.getDefault().getID();
        this.locale = Locale.getDefault().getISO3Country();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCalendarPath() {
        return this._calendarPath;
    }

    public void setCalendarPath(String path) {
        this._calendarPath = path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String[] editPermission) {
        this.editPermission = editPermission;
    }

    public String[] getViewPermission() {
        return this.viewPermission;
    }

    public void setViewPermission(String[] viewPermission) {
        this.viewPermission = viewPermission;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public boolean isPublic() {
        return this._isPublic;
    }

    public void setPublic(boolean isPublic) {
        this._isPublic = isPublic;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setCalendarColor(String calendarColor) {
        this.calendarColor = calendarColor;
    }

    public String getCalendarColor() {
        return this.calendarColor;
    }

    public void setDataInit(boolean isDataInit) {
        this._isDataInit = isDataInit;
    }

    public boolean isDataInit() {
        return this._isDataInit;
    }

    public void setCalendarOwner(String calendarOwner) {
        this.calendarOwner = calendarOwner;
    }

    public String getCalendarOwner() {
        return this.calendarOwner;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = this.removeDomainName(publicUrl);
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPrivateUrl(String privateUrl) {
        this.privateUrl = this.removeDomainName(privateUrl);
    }

    public String getPrivateUrl() {
        return this.privateUrl;
    }

    private String removeDomainName(String url) {
        if (url != null && url.indexOf("http") == 0) {
            url = url.substring(url.indexOf(":") + 3);
            url = url.substring(url.indexOf("/"));
        }
        return url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Calendar)) {
            return false;
        }
        return this.getId().equals(((Calendar)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int getCalType() {
        return this._calType;
    }

    public void setCalType(int calType) {
        this._calType = calType;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean children) {
        this.hasChildren = children;
    }

    public static enum Type {
        PERSONAL(0),
        SHARED(1),
        GROUP(2),
        UNDEFINED(-1);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }

        public Type getType(int type) {
            for (Type t : Type.values()) {
                if (t.type() != type) continue;
                return t;
            }
            return UNDEFINED;
        }
    }
}

