/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.user;

import org.exoplatform.forum.common.user.CommonContact;
import org.exoplatform.forum.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;

public class PersonalProfileContactProvider
implements ContactProvider {
    private static Log log = ExoLogger.getLogger(PersonalProfileContactProvider.class);
    private OrganizationService orgService;

    public PersonalProfileContactProvider(OrganizationService orgService) {
        this.orgService = orgService;
    }

    @Override
    public CommonContact getCommonContact(String userId) {
        CommonContact contact = new CommonContact();
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(userId);
            contact.setAvatarUrl(profile.getAttribute("user.other-info.avatar.url"));
            contact.setBirthday(profile.getAttribute("user.bdate"));
            contact.setGender(profile.getAttribute("user.gender"));
            contact.setJob(profile.getAttribute("user.jobtitle"));
            contact.setEmailAddress(profile.getAttribute("user.home-info.online.email"));
            contact.setCity(profile.getAttribute("user.home-info.postal.city"));
            contact.setCountry(profile.getAttribute("user.home-info.postal.country"));
            contact.setHomePhone(profile.getAttribute("user.home-info.telecom.mobile.number"));
            contact.setWorkPhone(profile.getAttribute("user.home-info.telecom.telephone.number"));
            contact.setWebSite(profile.getAttribute("user.home-info.online.uri"));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve forum user profile for " + userId + ": "), (Throwable)e);
        }
        return contact;
    }
}

