/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressedChangesBuffer {
    private int historyIndex = 0;
    private final List<BufferedJBossCache.ChangesContainer> changes = new ArrayList<BufferedJBossCache.ChangesContainer>();
    private final Map<Fqn, Map<Serializable, Object>> lastChanges = new HashMap<Fqn, Map<Serializable, Object>>();
    private final Map<String, List<BufferedJBossCache.ChangesContainer>> childNodesMap = new HashMap<String, List<BufferedJBossCache.ChangesContainer>>();
    private final Map<String, List<BufferedJBossCache.ChangesContainer>> childPropertyMap = new HashMap<String, List<BufferedJBossCache.ChangesContainer>>();
    private final boolean invalidationEnabled;

    public CompressedChangesBuffer() {
        this(false);
    }

    public CompressedChangesBuffer(boolean invalidationEnabled) {
        this.invalidationEnabled = invalidationEnabled;
    }

    public boolean isInvalidationEnabled() {
        return this.invalidationEnabled;
    }

    public void add(BufferedJBossCache.ChangesContainer container) {
        String parentCacheNode = (String)container.getFqn().get(1);
        if (container.getFqn().size() > 2 && JBossCacheWorkspaceStorageCache.CHILD_NODES.equals(parentCacheNode)) {
            this.optimize(this.childNodesMap, container);
        } else if (container.getFqn().size() > 2 && JBossCacheWorkspaceStorageCache.CHILD_PROPS.equals(parentCacheNode)) {
            this.optimize(this.childPropertyMap, container);
        } else {
            this.changes.add(container);
        }
        container.setInvalidation(this.invalidationEnabled);
        container.applyToBuffer(this);
    }

    public int getHistoryIndex() {
        ++this.historyIndex;
        return this.historyIndex;
    }

    public List<BufferedJBossCache.ChangesContainer> getSortedList() {
        List<BufferedJBossCache.ChangesContainer> changesContainers = this.listMap(this.childNodesMap);
        changesContainers.addAll(this.listMap(this.childPropertyMap));
        changesContainers.addAll(this.changes);
        Collections.sort(changesContainers);
        return changesContainers;
    }

    private void addToList(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap, String parent, BufferedJBossCache.ChangesContainer container) {
        List<BufferedJBossCache.ChangesContainer> changesContainers = childMap.get(parent);
        if (changesContainers == null) {
            changesContainers = new ArrayList<BufferedJBossCache.ChangesContainer>();
        }
        changesContainers.add(container);
        childMap.put(parent, changesContainers);
    }

    private List<BufferedJBossCache.ChangesContainer> listMap(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap) {
        ArrayList<BufferedJBossCache.ChangesContainer> containers = new ArrayList<BufferedJBossCache.ChangesContainer>();
        for (List<BufferedJBossCache.ChangesContainer> container : childMap.values()) {
            containers.addAll(container);
        }
        return containers;
    }

    private void optimize(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap, BufferedJBossCache.ChangesContainer container) {
        Fqn fqn = container.getFqn();
        String parent = (String)fqn.get(2);
        if (fqn.size() == 3 && container.getChangesType() == BufferedJBossCache.ChangesType.REMOVE) {
            childMap.remove(parent);
        }
        this.addToList(childMap, parent, container);
    }

    Object get(Fqn fqn, Serializable key) {
        Map<Serializable, Object> map = this.lastChanges.get(fqn);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    void put(Fqn fqn, Serializable key, Object value) {
        Map<Serializable, Object> map = this.lastChanges.get(fqn);
        if (map == null) {
            map = new HashMap<Serializable, Object>();
            this.lastChanges.put(fqn, map);
        }
        map.put(key, value);
    }

    public Map<Fqn, Map<Serializable, Object>> getLastChanges() {
        return this.lastChanges;
    }
}

